/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.AutoValue_GaugeData;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@AutoValue
public abstract class GaugeData
implements Serializable {
    public abstract long value();

    public abstract Instant timestamp();

    public static GaugeData create(long value) {
        return new AutoValue_GaugeData(value, Instant.now());
    }

    public static GaugeData empty() {
        return EmptyGaugeData.INSTANCE;
    }

    public GaugeData combine(GaugeData other) {
        if (this.timestamp().isAfter((ReadableInstant)other.timestamp())) {
            return this;
        }
        return other;
    }

    public GaugeResult extractResult() {
        return GaugeResult.create((long)this.value(), (Instant)this.timestamp());
    }

    public static class EmptyGaugeData
    extends GaugeData {
        private static final EmptyGaugeData INSTANCE = new EmptyGaugeData();
        private static final Instant EPOCH = new Instant(0L);

        private EmptyGaugeData() {
        }

        @Override
        public long value() {
            return -1L;
        }

        @Override
        public Instant timestamp() {
            return EPOCH;
        }

        @Override
        public GaugeResult extractResult() {
            return GaugeResult.empty();
        }
    }
}

