/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.DirtyState;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.GaugeData;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.MetricName;

@Experimental(value=Experimental.Kind.METRICS)
public class GaugeCell
implements Gauge,
MetricCell<GaugeData> {
    private final DirtyState dirty = new DirtyState();
    private final AtomicReference<GaugeData> gaugeValue = new AtomicReference<GaugeData>(GaugeData.empty());
    private final MetricName name;

    @Internal
    public GaugeCell(MetricName name) {
        this.name = name;
    }

    public void set(long value) {
        this.update(GaugeData.create(value));
    }

    void update(GaugeData data) {
        GaugeData original;
        while (!this.gaugeValue.compareAndSet(original = this.gaugeValue.get(), original.combine(data))) {
        }
        this.dirty.afterModification();
    }

    @Override
    public DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public GaugeData getCumulative() {
        return this.gaugeValue.get();
    }

    public MetricName getName() {
        return this.name;
    }
}

