/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Strings;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.hash.Funnels;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.hash.Hasher;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.hash.Hashing;
import org.apache.beam.sdk.util.ZipFiles;

public class PipelineResources {
    public static List<String> detectClassPathResourcesToStage(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            String message = String.format("Unable to use ClassLoader to detect classpath elements. Current ClassLoader is %s, only URLClassLoaders are supported.", classLoader);
            throw new IllegalArgumentException(message);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (URL url : ((URLClassLoader)classLoader).getURLs()) {
            try {
                files.add(new File(url.toURI()).getAbsolutePath());
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                String message = String.format("Unable to convert url (%s) to file.", url);
                throw new IllegalArgumentException(message, e);
            }
        }
        return files;
    }

    public static List<String> prepareFilesForStaging(List<String> resourcesToStage, String tmpJarLocation) {
        return resourcesToStage.stream().map(File::new).filter(File::exists).map(file -> file.isDirectory() ? PipelineResources.packageDirectoriesToStage(file, tmpJarLocation) : file.getAbsolutePath()).collect(Collectors.toList());
    }

    private static String packageDirectoriesToStage(File directoryToStage, String tmpJarLocation) {
        String hash = PipelineResources.calculateDirectoryContentHash(directoryToStage);
        String pathForJar = PipelineResources.getUniqueJarPath(hash, tmpJarLocation);
        PipelineResources.zipDirectory(directoryToStage, pathForJar);
        return pathForJar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String calculateDirectoryContentHash(File directoryToStage) {
        Hasher hasher = Hashing.sha256().newHasher();
        try (OutputStream hashStream = Funnels.asOutputStream(hasher);){
            ZipFiles.zipDirectory((File)directoryToStage, (OutputStream)hashStream);
            String string = hasher.hash().toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getUniqueJarPath(String contentHash, String tmpJarLocation) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(tmpJarLocation), "Please provide temporary location for storing the jar files.");
        return String.format("%s%s.jar", tmpJarLocation, contentHash);
    }

    private static void zipDirectory(File directoryToStage, String uniqueDirectoryPath) {
        try {
            ZipFiles.zipDirectory((File)directoryToStage, (OutputStream)new FileOutputStream(uniqueDirectoryPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

