/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.direct.portable.BundleFactory;
import org.apache.beam.runners.direct.portable.CommittedBundle;
import org.apache.beam.runners.direct.portable.EmptyInputProvider;
import org.apache.beam.runners.direct.portable.ImpulseEvaluatorFactory;
import org.apache.beam.runners.direct.portable.RootInputProvider;

class RootProviderRegistry {
    private final Map<String, RootInputProvider<?>> providers;

    static RootProviderRegistry javaPortableRegistry(BundleFactory bundleFactory) {
        return new RootProviderRegistry(ImmutableMap.builder().put(PTransformTranslation.IMPULSE_TRANSFORM_URN, new ImpulseEvaluatorFactory.ImpulseRootProvider(bundleFactory)).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, (ImpulseEvaluatorFactory.ImpulseRootProvider)((Object)new EmptyInputProvider())).build());
    }

    private RootProviderRegistry(Map<String, RootInputProvider<?>> providers) {
        this.providers = providers;
    }

    public Collection<CommittedBundle<?>> getInitialInputs(PipelineNode.PTransformNode transform, int targetParallelism) throws Exception {
        String transformUrn = PTransformTranslation.urnForTransformOrNull(transform.getTransform());
        RootInputProvider<?> provider = Preconditions.checkNotNull(this.providers.get(transformUrn), "Tried to get a %s for a transform \"%s\", but there is no such provider", (Object)RootInputProvider.class.getSimpleName(), (Object)transformUrn);
        return provider.getInitialInputs(transform, targetParallelism);
    }
}

