/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.direct.ExecutableGraph;
import org.apache.beam.runners.direct.portable.BundleFactory;
import org.apache.beam.runners.direct.portable.CommittedBundle;
import org.apache.beam.runners.direct.portable.RootInputProvider;
import org.apache.beam.runners.direct.portable.StepTransformResult;
import org.apache.beam.runners.direct.portable.TransformEvaluator;
import org.apache.beam.runners.direct.portable.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.portable.TransformResult;
import org.apache.beam.runners.direct.portable.UncommittedBundle;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;

class ImpulseEvaluatorFactory
implements TransformEvaluatorFactory {
    private final BundleFactory bundleFactory;
    private final ExecutableGraph<PipelineNode.PTransformNode, PipelineNode.PCollectionNode> graph;

    ImpulseEvaluatorFactory(ExecutableGraph<PipelineNode.PTransformNode, PipelineNode.PCollectionNode> graph, BundleFactory bundleFactory) {
        this.bundleFactory = bundleFactory;
        this.graph = graph;
    }

    @Override
    @Nullable
    public <InputT> TransformEvaluator<InputT> forApplication(PipelineNode.PTransformNode application, CommittedBundle<?> inputBundle) {
        return new ImpulseEvaluator(this.bundleFactory, application, Iterables.getOnlyElement(this.graph.getProduced(application)));
    }

    @Override
    public void cleanup() {
    }

    @VisibleForTesting
    static class ImpulseShard {
        ImpulseShard() {
        }
    }

    static class ImpulseRootProvider
    implements RootInputProvider<ImpulseShard> {
        private final BundleFactory bundleFactory;

        ImpulseRootProvider(BundleFactory bundleFactory) {
            this.bundleFactory = bundleFactory;
        }

        @Override
        public Collection<CommittedBundle<ImpulseShard>> getInitialInputs(PipelineNode.PTransformNode transform, int targetParallelism) {
            return Collections.singleton(this.bundleFactory.createRootBundle().add(WindowedValue.valueInGlobalWindow((Object)new ImpulseShard())).commit(BoundedWindow.TIMESTAMP_MIN_VALUE));
        }
    }

    private static class ImpulseEvaluator
    implements TransformEvaluator<ImpulseShard> {
        private final StepTransformResult.Builder<ImpulseShard> result;
        private final BundleFactory factory;
        private final PipelineNode.PCollectionNode outputPCollection;

        private ImpulseEvaluator(BundleFactory factory, PipelineNode.PTransformNode application, PipelineNode.PCollectionNode outputPCollection) {
            this.factory = factory;
            this.result = StepTransformResult.withoutHold(application);
            this.outputPCollection = outputPCollection;
        }

        @Override
        public void processElement(WindowedValue<ImpulseShard> element) throws Exception {
            this.result.addOutput(this.factory.createBundle(this.outputPCollection).add(WindowedValue.valueInGlobalWindow((Object)new byte[0])), new UncommittedBundle[0]);
        }

        @Override
        public TransformResult<ImpulseShard> finishBundle() throws Exception {
            return this.result.build();
        }
    }
}

