/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;

class DisplayDataValidator {
    private DisplayDataValidator() {
    }

    static void validatePipeline(Pipeline pipeline) {
        DisplayDataValidator.validateTransforms(pipeline);
    }

    static void validateOptions(PipelineOptions options) {
        DisplayDataValidator.evaluateDisplayData((HasDisplayData)options);
    }

    private static void validateTransforms(Pipeline pipeline) {
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)Visitor.INSTANCE);
    }

    private static void evaluateDisplayData(HasDisplayData component) {
        DisplayData.from((HasDisplayData)component);
    }

    private static class Visitor
    extends Pipeline.PipelineVisitor.Defaults {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
        }

        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (!node.isRootNode()) {
                DisplayDataValidator.evaluateDisplayData((HasDisplayData)node.getTransform());
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            DisplayDataValidator.evaluateDisplayData((HasDisplayData)node.getTransform());
        }
    }
}

