/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ListMultimap;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineValidator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;

public class PipelineTranslation {
    public static RunnerApi.Pipeline toProto(Pipeline pipeline) {
        return PipelineTranslation.toProto(pipeline, SdkComponents.create(pipeline.getOptions()));
    }

    public static RunnerApi.Pipeline toProto(final Pipeline pipeline, final SdkComponents components) {
        final HashSet rootIds = new HashSet();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){
            private final ListMultimap<TransformHierarchy.Node, AppliedPTransform<?, ?, ?>> children = ArrayListMultimap.create();

            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                if (node.isRootNode()) {
                    for (AppliedPTransform<?, ?, ?> pipelineRoot : this.children.get(node)) {
                        rootIds.add(components.getExistingPTransformId(pipelineRoot));
                    }
                } else {
                    this.children.put(node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                    try {
                        components.registerPTransform(node.toAppliedPTransform(pipeline), this.children.get(node));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                this.children.put(node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                try {
                    components.registerPTransform(node.toAppliedPTransform(pipeline), Collections.emptyList());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        RunnerApi.Pipeline res = RunnerApi.Pipeline.newBuilder().setComponents(components.toComponents()).addAllRootTransformIds(rootIds).build();
        PipelineValidator.validate(res);
        return res;
    }
}

