/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Joiner;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Sets;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.DisplayDataTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.ParDoTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ProtocolMessageEnum;

public class PTransformTranslation {
    public static final String PAR_DO_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.PAR_DO);
    public static final String FLATTEN_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.FLATTEN);
    public static final String GROUP_BY_KEY_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.GROUP_BY_KEY);
    public static final String IMPULSE_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.IMPULSE);
    public static final String ASSIGN_WINDOWS_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.ASSIGN_WINDOWS);
    public static final String TEST_STREAM_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.TEST_STREAM);
    public static final String MAP_WINDOWS_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Primitives.MAP_WINDOWS);
    @Deprecated
    public static final String READ_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.DeprecatedPrimitives.READ);
    @Deprecated
    public static final String CREATE_VIEW_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.DeprecatedPrimitives.CREATE_VIEW);
    public static final String COMBINE_PER_KEY_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.COMBINE_PER_KEY);
    public static final String COMBINE_GLOBALLY_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.COMBINE_GLOBALLY);
    public static final String RESHUFFLE_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.RESHUFFLE);
    public static final String WRITE_FILES_TRANSFORM_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.Composites.WRITE_FILES);
    public static final String SPLITTABLE_PAIR_WITH_RESTRICTION_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PAIR_WITH_RESTRICTION);
    public static final String SPLITTABLE_SPLIT_RESTRICTION_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.SPLIT_RESTRICTION);
    public static final String SPLITTABLE_PROCESS_KEYED_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PROCESS_KEYED_ELEMENTS);
    public static final String SPLITTABLE_PROCESS_ELEMENTS_URN = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardPTransforms.SplittableParDoComponents.PROCESS_ELEMENTS);
    public static final String ITERABLE_SIDE_INPUT = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardSideInputTypes.Enum.ITERABLE);
    public static final String MULTIMAP_SIDE_INPUT = BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardSideInputTypes.Enum.MULTIMAP);
    private static final Collection<TransformTranslator<?>> KNOWN_TRANSLATORS = PTransformTranslation.loadKnownTranslators();

    private static Collection<TransformTranslator<?>> loadKnownTranslators() {
        return ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(ReflectHelpers.ObjectsClassComparator.INSTANCE).add(new RawPTransformTranslator())).add(new KnownTransformPayloadTranslator())).add(ParDoTranslation.ParDoTranslator.create())).build();
    }

    private PTransformTranslation() {
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
        TransformTranslator transformTranslator = Iterables.find(KNOWN_TRANSLATORS, translator -> translator.canTranslate(appliedPTransform.getTransform()), DefaultUnknownTransformTranslator.INSTANCE);
        return transformTranslator.translate(appliedPTransform, subtransforms, components);
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, SdkComponents components) throws IOException {
        return PTransformTranslation.toProto(appliedPTransform, Collections.emptyList(), components);
    }

    private static String toProto(TupleTag<?> tag) {
        return tag.getId();
    }

    @Nullable
    public static String urnForTransformOrNull(PTransform<?, ?> transform) {
        TransformTranslator transformTranslator = Iterables.find(KNOWN_TRANSLATORS, translator -> translator.canTranslate(transform), DefaultUnknownTransformTranslator.INSTANCE);
        return transformTranslator.getUrn(transform);
    }

    public static String urnForTransform(PTransform<?, ?> transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        if (urn == null) {
            throw new IllegalStateException(String.format("No translator known for %s", transform.getClass().getName()));
        }
        return urn;
    }

    @Nullable
    public static String urnForTransformOrNull(RunnerApi.PTransform transform) {
        return transform.getSpec() == null ? null : transform.getSpec().getUrn();
    }

    static RunnerApi.PTransform.Builder translateAppliedPTransform(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
        RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
        for (Map.Entry entry : appliedPTransform.getInputs().entrySet()) {
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected input type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putInputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (Map.Entry entry : appliedPTransform.getOutputs().entrySet()) {
            if (!(entry.getValue() instanceof PCollection)) continue;
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected output type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putOutputs(PTransformTranslation.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (AppliedPTransform appliedPTransform2 : subtransforms) {
            transformBuilder.addSubtransforms(components.getExistingPTransformId(appliedPTransform2));
        }
        transformBuilder.setUniqueName(appliedPTransform.getFullName());
        transformBuilder.setDisplayData(DisplayDataTranslation.toProto(DisplayData.from((HasDisplayData)appliedPTransform.getTransform())));
        return transformBuilder;
    }

    public static abstract class RawPTransform<InputT extends PInput, OutputT extends POutput>
    extends PTransform<InputT, OutputT> {
        @Nullable
        public String getUrn() {
            return this.getSpec() == null ? null : this.getSpec().getUrn();
        }

        @Nullable
        public abstract RunnerApi.FunctionSpec getSpec();

        public RunnerApi.FunctionSpec migrate(SdkComponents components) throws IOException {
            return this.getSpec();
        }

        public OutputT expand(InputT input) {
            throw new IllegalStateException(String.format("%s should never be asked to expand; it is the result of deserializing an already-constructed Pipeline", ((Object)((Object)this)).getClass().getSimpleName()));
        }
    }

    public static interface TransformPayloadTranslator<T extends PTransform<?, ?>> {
        public String getUrn(T var1);

        @Nullable
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> var1, SdkComponents var2) throws IOException;

        public static abstract class NotSerializable<T extends PTransform<?, ?>>
        implements TransformPayloadTranslator<T> {
            public static NotSerializable<?> forUrn(final String urn) {
                return new NotSerializable<PTransform<?, ?>>(){

                    @Override
                    public String getUrn(PTransform<?, ?> transform) {
                        return urn;
                    }
                };
            }

            @Override
            public final RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> transform, SdkComponents components) throws IOException {
                throw new UnsupportedOperationException(String.format("%s should never be translated", transform.getTransform().getClass().getCanonicalName()));
            }
        }
    }

    private static class KnownTransformPayloadTranslator<T extends PTransform<?, ?>>
    implements TransformTranslator<T> {
        private static final Map<Class<? extends PTransform>, TransformPayloadTranslator> KNOWN_PAYLOAD_TRANSLATORS = KnownTransformPayloadTranslator.loadTransformPayloadTranslators();

        private KnownTransformPayloadTranslator() {
        }

        private static Map<Class<? extends PTransform>, TransformPayloadTranslator> loadTransformPayloadTranslators() {
            HashMap<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> translators = new HashMap<Class<? extends PTransform>, TransformPayloadTranslator>();
            for (TransformPayloadTranslatorRegistrar registrar : ServiceLoader.load(TransformPayloadTranslatorRegistrar.class)) {
                Map<? extends Class<? extends PTransform>, ? extends TransformPayloadTranslator> newTranslators = registrar.getTransformPayloadTranslators();
                Sets.SetView alreadyRegistered = Sets.intersection(translators.keySet(), newTranslators.keySet());
                if (!alreadyRegistered.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Classes already registered: %s", Joiner.on(", ").join(alreadyRegistered)));
                }
                translators.putAll(newTranslators);
            }
            return ImmutableMap.copyOf(translators);
        }

        @Override
        public boolean canTranslate(PTransform pTransform) {
            return KNOWN_PAYLOAD_TRANSLATORS.containsKey(pTransform.getClass());
        }

        @Override
        public String getUrn(PTransform transform) {
            return KNOWN_PAYLOAD_TRANSLATORS.get(transform.getClass()).getUrn(transform);
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            RunnerApi.PTransform.Builder transformBuilder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            RunnerApi.FunctionSpec spec = KNOWN_PAYLOAD_TRANSLATORS.get(appliedPTransform.getTransform().getClass()).translate(appliedPTransform, components);
            if (spec != null) {
                transformBuilder.setSpec(spec);
            }
            return transformBuilder.build();
        }
    }

    private static class RawPTransformTranslator
    implements TransformTranslator<RawPTransform<?, ?>> {
        private RawPTransformTranslator() {
        }

        @Override
        public String getUrn(RawPTransform transform) {
            return transform.getUrn();
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return pTransform instanceof RawPTransform;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            RunnerApi.PTransform.Builder transformBuilder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            PTransform transform = appliedPTransform.getTransform();
            RunnerApi.FunctionSpec spec = ((RawPTransform)transform).migrate(components);
            if (spec != null) {
                transformBuilder.setSpec(spec);
            }
            return transformBuilder.build();
        }
    }

    private static class DefaultUnknownTransformTranslator
    implements TransformTranslator<PTransform<?, ?>> {
        private static final TransformTranslator<?> INSTANCE = new DefaultUnknownTransformTranslator();

        private DefaultUnknownTransformTranslator() {
        }

        @Override
        public String getUrn(PTransform<?, ?> transform) {
            return null;
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return true;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            return PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components).build();
        }
    }

    public static interface TransformTranslator<T extends PTransform<?, ?>> {
        @Nullable
        public String getUrn(T var1);

        public boolean canTranslate(PTransform<?, ?> var1);

        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> var1, List<AppliedPTransform<?, ?, ?>> var2, SdkComponents var3) throws IOException;
    }
}

