/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.InMemoryStateInternals;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.StateTag;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class TestInMemoryStateInternals<K>
extends InMemoryStateInternals<K> {
    public TestInMemoryStateInternals(K key) {
        super(key);
    }

    public Set<StateTag> getTagsInUse(StateNamespace namespace) {
        HashSet<StateTag> inUse = new HashSet<StateTag>();
        for (Map.Entry<StateTag, State> entry : this.inMemoryState.getTagsInUse(namespace).entrySet()) {
            if (this.isEmptyForTesting(entry.getValue())) continue;
            inUse.add(entry.getKey());
        }
        return inUse;
    }

    public Set<StateNamespace> getNamespacesInUse() {
        return this.inMemoryState.getNamespacesInUse();
    }

    public Instant earliestWatermarkHold() {
        Instant minimum = null;
        for (State storage : this.inMemoryState.values()) {
            if (!(storage instanceof WatermarkHoldState)) continue;
            Instant hold = (Instant)((WatermarkHoldState)storage).read();
            if (minimum != null && (hold == null || !hold.isBefore((ReadableInstant)minimum))) continue;
            minimum = hold;
        }
        return minimum;
    }
}

