/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.resources;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.classgraph.ClassGraph;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.construction.resources.ClasspathScanningResourcesDetector;
import org.apache.beam.sdk.util.construction.resources.PipelineResourcesDetector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface PipelineResourcesOptions
extends PipelineOptions {
    @JsonIgnore
    @Description(value="The class of the pipeline resources detector factory that should be created and used to create the detector. If not set explicitly, a default class will be used to instantiate the factory.")
    @Default.Class(value=ClasspathScanningResourcesDetectorFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineResourcesDetector.Factory> getPipelineResourcesDetectorFactoryClass();

    public void setPipelineResourcesDetectorFactoryClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineResourcesDetector.Factory> var1);

    @JsonIgnore
    @Description(value="Instance of a pipeline resources detection algorithm. If not set explicitly, a default implementation will be used")
    @Default.InstanceFactory(value=PipelineResourcesDetectorFactory.class)
    public @UnknownKeyFor @NonNull @Initialized PipelineResourcesDetector getPipelineResourcesDetector();

    public void setPipelineResourcesDetector(@UnknownKeyFor @NonNull @Initialized PipelineResourcesDetector var1);

    public static class ClasspathScanningResourcesDetectorFactory
    implements PipelineResourcesDetector.Factory {
        public static @UnknownKeyFor @NonNull @Initialized ClasspathScanningResourcesDetectorFactory create() {
            return new ClasspathScanningResourcesDetectorFactory();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineResourcesDetector getPipelineResourcesDetector() {
            return new ClasspathScanningResourcesDetector(new ClassGraph());
        }
    }

    public static class PipelineResourcesDetectorFactory
    implements DefaultValueFactory<PipelineResourcesDetector> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineResourcesDetector create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            PipelineResourcesOptions resourcesOptions = options.as(PipelineResourcesOptions.class);
            PipelineResourcesDetector.Factory resourcesToStage = InstanceBuilder.ofType(PipelineResourcesDetector.Factory.class).fromClass(resourcesOptions.getPipelineResourcesDetectorFactoryClass()).fromFactoryMethod("create").build();
            return resourcesToStage.getPipelineResourcesDetector();
        }
    }
}

