/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.util.Map;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class ForwardingPTransform<@UnknownKeyFor InputT extends @UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput>
extends PTransform<InputT, OutputT> {
    protected abstract @UnknownKeyFor @NonNull @Initialized PTransform<InputT, OutputT> delegate();

    @Override
    public OutputT expand(InputT input) {
        OutputT res = this.delegate().expand(input);
        if (res instanceof PCollection) {
            PCollection pc = (PCollection)res;
            try {
                pc.setCoder(this.delegate().getDefaultOutputCoder(input, pc));
            }
            catch (CannotProvideCoderException cannotProvideCoderException) {
                // empty catch block
            }
        }
        return res;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
        return this.delegate().getAdditionalInputs();
    }

    @Override
    public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.delegate().validate(options);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.delegate().getName();
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.delegate(this.delegate());
    }
}

