/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.io.fs.AutoValue_MatchResult_Failure;
import org.apache.beam.sdk.io.fs.AutoValue_MatchResult_Metadata;
import org.apache.beam.sdk.io.fs.AutoValue_MatchResult_Success;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class MatchResult {
    private MatchResult() {
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchResult create(@UnknownKeyFor @NonNull @Initialized Status status, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Metadata> metadata) {
        return new AutoValue_MatchResult_Success(status, metadata);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchResult create(@UnknownKeyFor @NonNull @Initialized Status status, @UnknownKeyFor @NonNull @Initialized IOException e) {
        return new AutoValue_MatchResult_Failure(status, e);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchResult unknown() {
        return new AutoValue_MatchResult_Failure(Status.UNKNOWN, new IOException("MatchResult status is UNKNOWN, and metadata is not available."));
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Status status();

    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Metadata> metadata() throws @UnknownKeyFor @NonNull @Initialized IOException;

    public static enum Status {
        UNKNOWN,
        OK,
        NOT_FOUND,
        ERROR;

    }

    @AutoValue
    public static abstract class Metadata
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long UNKNOWN_LAST_MODIFIED_MILLIS = 0L;

        public abstract @UnknownKeyFor @NonNull @Initialized ResourceId resourceId();

        public abstract @UnknownKeyFor @NonNull @Initialized long sizeBytes();

        public abstract @UnknownKeyFor @NonNull @Initialized boolean isReadSeekEfficient();

        public abstract @Nullable @UnknownKeyFor @Initialized String checksum();

        public abstract @UnknownKeyFor @NonNull @Initialized long lastModifiedMillis();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_MatchResult_Metadata.Builder().setIsReadSeekEfficient(false).setLastModifiedMillis(0L);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setResourceId(@UnknownKeyFor @NonNull @Initialized ResourceId var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setIsReadSeekEfficient(@UnknownKeyFor @NonNull @Initialized boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLastModifiedMillis(@UnknownKeyFor @NonNull @Initialized long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setChecksum(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Metadata build();
        }
    }

    @AutoValue
    static abstract class Failure
    extends MatchResult {
        Failure() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized IOException getException();

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Metadata> metadata() throws @UnknownKeyFor @NonNull @Initialized IOException {
            throw this.getException();
        }
    }

    @AutoValue
    static abstract class Success
    extends MatchResult {
        Success() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Metadata> getMetadata();

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Metadata> metadata() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.getMetadata();
        }
    }
}

