/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.LocalFileSystem;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.TreeMultimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FileSystems {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SCHEME = "file";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern FILE_SCHEME_PATTERN = Pattern.compile("(?<scheme>[a-zA-Z][-a-zA-Z0-9+.]*):/.*");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern GLOB_PATTERN = Pattern.compile("[*?{}]");
    private static final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Integer>> FILESYSTEM_REVISION = new AtomicReference();
    private static final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FileSystem>> SCHEME_TO_FILESYSTEM = new AtomicReference<ImmutableMap>(ImmutableMap.of((Object)"file", (Object)new LocalFileSystem()));

    public static @UnknownKeyFor @NonNull @Initialized boolean hasGlobWildcard(@UnknownKeyFor @NonNull @Initialized String spec) {
        return GLOB_PATTERN.matcher(spec).find();
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystems.getFileSystemInternal(FileSystems.getOnlyScheme(specs)).match(specs);
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<MatchResult> matches = FileSystems.getFileSystemInternal(FileSystems.getOnlyScheme(specs)).match(specs);
        ArrayList res = Lists.newArrayListWithExpectedSize((int)matches.size());
        for (int i = 0; i < matches.size(); ++i) {
            res.add(FileSystems.maybeAdjustEmptyMatchResult(specs.get(i), matches.get(i), emptyMatchTreatment));
        }
        return res;
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchResult match(@UnknownKeyFor @NonNull @Initialized String spec) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<MatchResult> matches = FileSystems.match(Collections.singletonList(spec));
        Verify.verify((matches.size() == 1 ? 1 : 0) != 0, (String)"FileSystem implementation for %s did not return exactly one MatchResult: %s", (Object)spec, matches);
        return matches.get(0);
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchResult match(@UnknownKeyFor @NonNull @Initialized String spec, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment) throws @UnknownKeyFor @NonNull @Initialized IOException {
        MatchResult res = FileSystems.match(spec);
        return FileSystems.maybeAdjustEmptyMatchResult(spec, res, emptyMatchTreatment);
    }

    private static @UnknownKeyFor @NonNull @Initialized MatchResult maybeAdjustEmptyMatchResult(@UnknownKeyFor @NonNull @Initialized String spec, @UnknownKeyFor @NonNull @Initialized MatchResult res, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (res.status() == MatchResult.Status.NOT_FOUND || res.status() == MatchResult.Status.OK && res.metadata().isEmpty()) {
            boolean notFoundAllowed = emptyMatchTreatment == EmptyMatchTreatment.ALLOW || FileSystems.hasGlobWildcard(spec) && emptyMatchTreatment == EmptyMatchTreatment.ALLOW_IF_WILDCARD;
            return notFoundAllowed ? MatchResult.create(MatchResult.Status.OK, Collections.emptyList()) : MatchResult.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException("No files matched spec: " + spec));
        }
        return res;
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata matchSingleFileSpec(@UnknownKeyFor @NonNull @Initialized String spec) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<MatchResult> matches = FileSystems.match(Collections.singletonList(spec));
        MatchResult matchResult = (MatchResult)Iterables.getOnlyElement(matches);
        if (matchResult.status() == MatchResult.Status.NOT_FOUND) {
            throw new FileNotFoundException(String.format("File spec %s not found", spec));
        }
        if (matchResult.status() != MatchResult.Status.OK) {
            throw new IOException(String.format("Error matching file spec %s: status %s", new Object[]{spec, matchResult.status()}));
        }
        List<MatchResult.Metadata> metadata = matchResult.metadata();
        if (metadata.size() != 1) {
            throw new IOException(String.format("Expecting spec %s to match exactly one file, but matched %s: %s", spec, metadata.size(), metadata));
        }
        return metadata.get(0);
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> matchResources(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> resourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystems.match((List<String>)FluentIterable.from(resourceIds).transform(ResourceId::toString).toList());
    }

    public static @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized ResourceId resourceId, @UnknownKeyFor @NonNull @Initialized String mimeType) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystems.create(resourceId, ((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType(mimeType)).build());
    }

    public static @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized ResourceId resourceId, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystems.getFileSystemInternal(resourceId.getScheme()).create(resourceId, createOptions);
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadableByteChannel open(@UnknownKeyFor @NonNull @Initialized ResourceId resourceId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystems.getFileSystemInternal(resourceId.getScheme()).open(resourceId);
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        FileSystems.validateSrcDestLists(srcResourceIds, destResourceIds);
        if (srcResourceIds.isEmpty()) {
            return;
        }
        FileSystem fileSystem = FileSystems.getFileSystemInternal(srcResourceIds.iterator().next().getScheme());
        FilterResult filtered = FileSystems.filterFiles(fileSystem, srcResourceIds, destResourceIds, moveOptions);
        if (!filtered.resultSources.isEmpty()) {
            fileSystem.copy(filtered.resultSources, filtered.resultDestinations);
        }
    }

    public static void rename(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        FileSystems.validateSrcDestLists(srcResourceIds, destResourceIds);
        if (srcResourceIds.isEmpty()) {
            return;
        }
        FileSystems.renameInternal(FileSystems.getFileSystemInternal(srcResourceIds.iterator().next().getScheme()), srcResourceIds, destResourceIds, moveOptions);
    }

    @VisibleForTesting
    static void renameInternal(@UnknownKeyFor @NonNull @Initialized FileSystem fileSystem, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        block3: {
            try {
                fileSystem.rename(srcResourceIds, destResourceIds, moveOptions);
            }
            catch (UnsupportedOperationException e) {
                FilterResult filtered = FileSystems.filterFiles(fileSystem, srcResourceIds, destResourceIds, moveOptions);
                if (!filtered.resultSources.isEmpty()) {
                    fileSystem.rename(filtered.resultSources, filtered.resultDestinations, new MoveOptions[0]);
                }
                if (filtered.filteredExistingSrcs.isEmpty()) break block3;
                fileSystem.delete(filtered.filteredExistingSrcs);
            }
        }
    }

    public static void delete(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ResourceId> resourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (resourceIds.isEmpty()) {
            return;
        }
        ImmutableList resourceIdsToDelete = Sets.newHashSet((Object[])moveOptions).contains(MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES) ? FluentIterable.from(FileSystems.matchResources(Lists.newArrayList(resourceIds))).filter(matchResult -> !matchResult.status().equals((Object)MatchResult.Status.NOT_FOUND)).transformAndConcat((Function)new Function<MatchResult, Iterable<MatchResult.Metadata>>(){

            @Nonnull
            @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
            public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> apply(@Nonnull @UnknownKeyFor @NonNull @Initialized MatchResult input) {
                try {
                    return Lists.newArrayList(input.metadata());
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to get metadata from MatchResult: %s.", input), e);
                }
            }
        }).transform((Function)new Function<MatchResult.Metadata, ResourceId>(){

            @Nonnull
            @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
            public @UnknownKeyFor @NonNull @Initialized ResourceId apply(@Nonnull @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata input) {
                return input.resourceId();
            }
        }).toList() : resourceIds;
        if (resourceIdsToDelete.isEmpty()) {
            return;
        }
        FileSystems.getFileSystemInternal(resourceIdsToDelete.iterator().next().getScheme()).delete(resourceIdsToDelete);
    }

    private static @UnknownKeyFor @NonNull @Initialized FilterResult filterFiles(@UnknownKeyFor @NonNull @Initialized FileSystem fileSystem, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        FilterResult result = new FilterResult();
        if (moveOptions.length == 0 || srcResourceIds.isEmpty()) {
            result.resultSources = srcResourceIds;
            result.resultDestinations = destResourceIds;
            return result;
        }
        HashSet moveOptionSet = Sets.newHashSet((Object[])moveOptions);
        boolean ignoreMissingSrc = moveOptionSet.contains(MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
        boolean skipExistingDest = moveOptionSet.contains(MoveOptions.StandardMoveOptions.SKIP_IF_DESTINATION_EXISTS);
        int size = srcResourceIds.size();
        ArrayList<ResourceId> matchResources = new ArrayList<ResourceId>();
        if (ignoreMissingSrc) {
            matchResources.addAll(srcResourceIds);
        }
        if (skipExistingDest) {
            matchResources.addAll(destResourceIds);
        }
        List<MatchResult> matchResults = fileSystem.match((List<String>)FluentIterable.from(matchResources).transform(ResourceId::toString).toList());
        List<MatchResult> matchSrcResults = ignoreMissingSrc ? matchResults.subList(0, size) : null;
        List<MatchResult> matchDestResults = skipExistingDest ? matchResults.subList(matchResults.size() - size, matchResults.size()) : null;
        for (int i = 0; i < size; ++i) {
            if (matchSrcResults != null && matchSrcResults.get(i).status().equals((Object)MatchResult.Status.NOT_FOUND)) continue;
            if (matchDestResults != null && matchSrcResults != null && matchDestResults.get(i).status().equals((Object)MatchResult.Status.OK) && FileSystems.checksumMatch(matchDestResults.get(i).metadata().get(0), matchSrcResults.get(i).metadata().get(0))) {
                result.filteredExistingSrcs.add(srcResourceIds.get(i));
                continue;
            }
            result.resultSources.add(srcResourceIds.get(i));
            result.resultDestinations.add(destResourceIds.get(i));
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean checksumMatch(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata first, @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata second) {
        return first.checksum() != null && first.checksum().equals(second.checksum());
    }

    private static void validateSrcDestLists(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> destResourceIds) {
        Preconditions.checkArgument((srcResourceIds.size() == destResourceIds.size() ? 1 : 0) != 0, (String)"Number of source resource ids %s must equal number of destination resource ids %s", (int)srcResourceIds.size(), (int)destResourceIds.size());
        if (srcResourceIds.isEmpty()) {
            return;
        }
        ImmutableSet schemes = FluentIterable.from(srcResourceIds).append(destResourceIds).transform(ResourceId::getScheme).toSet();
        Preconditions.checkArgument((schemes.size() == 1 ? 1 : 0) != 0, (Object)String.format("Expect srcResourceIds and destResourceIds have the same scheme, but received %s.", Joiner.on((String)", ").join((Iterable)schemes)));
    }

    private static @UnknownKeyFor @NonNull @Initialized String getOnlyScheme(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) {
        Preconditions.checkArgument((!specs.isEmpty() ? 1 : 0) != 0, (Object)"Expect specs are not empty.");
        ImmutableSet schemes = FluentIterable.from(specs).transform(FileSystems::parseScheme).toSet();
        return (String)Iterables.getOnlyElement((Iterable)schemes);
    }

    private static @UnknownKeyFor @NonNull @Initialized String parseScheme(@UnknownKeyFor @NonNull @Initialized String spec) {
        Matcher matcher = FILE_SCHEME_PATTERN.matcher(spec);
        if (!matcher.matches()) {
            return DEFAULT_SCHEME;
        }
        return matcher.group("scheme").toLowerCase();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized FileSystem getFileSystemInternal(@UnknownKeyFor @NonNull @Initialized String scheme) {
        String lowerCaseScheme = scheme.toLowerCase();
        Map<String, FileSystem> schemeToFileSystem = SCHEME_TO_FILESYSTEM.get();
        FileSystem rval = schemeToFileSystem.get(lowerCaseScheme);
        if (rval == null) {
            throw new IllegalArgumentException("No filesystem found for scheme " + scheme);
        }
        return rval;
    }

    @Internal
    public static void setDefaultPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        KV<Long, Integer> revision;
        Preconditions.checkNotNull((Object)options, (Object)"options");
        long id = options.getOptionsId();
        int nextRevision = options.revision();
        do {
            if ((revision = FILESYSTEM_REVISION.get()) == null || !revision.getKey().equals(id) || revision.getValue() < nextRevision) continue;
            return;
        } while (!FILESYSTEM_REVISION.compareAndSet(revision, KV.of(id, nextRevision)));
        TreeSet registrars = Sets.newTreeSet((Comparator)ReflectHelpers.ObjectsClassComparator.INSTANCE);
        registrars.addAll(Lists.newArrayList(ServiceLoader.load(FileSystemRegistrar.class, ReflectHelpers.findClassLoader())));
        SCHEME_TO_FILESYSTEM.set(FileSystems.verifySchemesAreUnique(options, registrars));
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FileSystem> verifySchemesAreUnique(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized FileSystemRegistrar> registrars) {
        TreeMultimap fileSystemsBySchemes = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.arbitrary());
        for (FileSystemRegistrar fileSystemRegistrar : registrars) {
            for (FileSystem<?> fileSystem : fileSystemRegistrar.fromOptions(options)) {
                fileSystemsBySchemes.put((Object)fileSystem.getScheme(), fileSystem);
            }
        }
        for (Map.Entry entry : fileSystemsBySchemes.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            String conflictingFileSystems = Joiner.on((String)", ").join((Iterable)FluentIterable.from((Iterable)((Iterable)entry.getValue())).transform(input -> input.getClass().getName()).toSortedList((Comparator)Ordering.natural()));
            throw new IllegalStateException(String.format("Scheme: [%s] has conflicting filesystems: [%s]", entry.getKey(), conflictingFileSystems));
        }
        ImmutableMap.Builder schemeToFileSystem = ImmutableMap.builder();
        for (Map.Entry entry : fileSystemsBySchemes.entries()) {
            schemeToFileSystem.put((Object)((String)entry.getKey()), (Object)((FileSystem)entry.getValue()));
        }
        return schemeToFileSystem.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ResourceId matchNewResource(@UnknownKeyFor @NonNull @Initialized String singleResourceSpec, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        return FileSystems.getFileSystemInternal(FileSystems.parseScheme(singleResourceSpec)).matchNewResource(singleResourceSpec, isDirectory);
    }

    public static @UnknownKeyFor @NonNull @Initialized ResourceId matchNewDirectory(@UnknownKeyFor @NonNull @Initialized String singleResourceSpec, String ... baseNames) {
        ResourceId currentDir = FileSystems.matchNewResource(singleResourceSpec, true);
        for (String dir : baseNames) {
            currentDir = currentDir.resolve(dir, ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        }
        return currentDir;
    }

    private static class FilterResult {
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> resultSources = new ArrayList<ResourceId>();
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> resultDestinations = new ArrayList<ResourceId>();
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> filteredExistingSrcs = new ArrayList<ResourceId>();

        private FilterResult() {
        }
    }
}

