/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.MultimapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Equivalence;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class StateTags {
    public static final @UnknownKeyFor @NonNull @Initialized Equivalence<@UnknownKeyFor @NonNull @Initialized StateTag> ID_EQUIVALENCE = new Equivalence<StateTag>(){

        protected @UnknownKeyFor @NonNull @Initialized boolean doEquivalent(@UnknownKeyFor @NonNull @Initialized StateTag a, @UnknownKeyFor @NonNull @Initialized StateTag b) {
            return a.getId().equals(b.getId());
        }

        protected @UnknownKeyFor @NonNull @Initialized int doHash(@UnknownKeyFor @NonNull @Initialized StateTag stateTag) {
            return stateTag.getId().hashCode();
        }
    };

    @Deprecated
    private static @UnknownKeyFor @NonNull @Initialized StateBinder adaptTagBinder(final @UnknownKeyFor @NonNull @Initialized StateTag.StateBinder binder) {
        return new StateBinder(){

            @Override
            public <T> @UnknownKeyFor @NonNull @Initialized ValueState<T> bindValue(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
                return binder.bindValue(StateTags.tagForSpec(id, spec), coder);
            }

            @Override
            public <T> @UnknownKeyFor @NonNull @Initialized BagState<T> bindBag(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                return binder.bindBag(StateTags.tagForSpec(id, spec), elemCoder);
            }

            @Override
            public <T> @UnknownKeyFor @NonNull @Initialized SetState<T> bindSet(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized SetState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                return binder.bindSet(StateTags.tagForSpec(id, spec), elemCoder);
            }

            @Override
            public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT> bindMap(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> mapKeyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> mapValueCoder) {
                return binder.bindMap(StateTags.tagForSpec(id, spec), mapKeyCoder, mapValueCoder);
            }

            @Override
            public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT> bindMultimap(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
                return binder.bindMultimap(StateTags.tagForSpec(id, spec), keyCoder, valueCoder);
            }

            @Override
            public <T> @UnknownKeyFor @NonNull @Initialized OrderedListState<T> bindOrderedList(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized OrderedListState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
                return binder.bindOrderedList(StateTags.tagForSpec(id, spec), elemCoder);
            }

            @Override
            public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombining(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
                return binder.bindCombiningValue(StateTags.tagForSpec(id, spec), accumCoder, combineFn);
            }

            @Override
            public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningWithContext(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
                return binder.bindCombiningValueWithContext(StateTags.tagForSpec(id, spec), accumCoder, combineFn);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized WatermarkHoldState bindWatermark(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> spec, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
                return binder.bindWatermark(StateTags.tagForSpec(id, spec), timestampCombiner);
            }
        };
    }

    private StateTags() {
    }

    public static <StateT extends State> @UnknownKeyFor @NonNull @Initialized StateTag<StateT> tagForSpec(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<StateT> spec) {
        return new SimpleStateTag<StateT>(new StructuredId(id), spec);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<T>> value(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        return new SimpleStateTag<ValueState<T>>(new StructuredId(id), StateSpecs.value(valueCoder));
    }

    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningValue(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new SimpleStateTag<CombiningState<InputT, AccumT, OutputT>>(new StructuredId(id), StateSpecs.combining(accumCoder, combineFn));
    }

    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningValueWithContext(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return new SimpleStateTag<CombiningState<InputT, AccumT, OutputT>>(new StructuredId(id), StateSpecs.combining(accumCoder, combineFn));
    }

    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningValueFromInputInternal(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new SimpleStateTag<CombiningState<InputT, AccumT, OutputT>>(new StructuredId(id), StateSpecs.combiningFromInputInternal(inputCoder, combineFn));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> bag(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new SimpleStateTag<BagState<T>>(new StructuredId(id), StateSpecs.bag(elemCoder));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized SetState<T>> set(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new SimpleStateTag<SetState<T>>(new StructuredId(id), StateSpecs.set(elemCoder));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MapState<K, V>> map(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new SimpleStateTag<MapState<K, V>>(new StructuredId(id), StateSpecs.map(keyCoder, valueCoder));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MultimapState<K, V>> multimap(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new SimpleStateTag<MultimapState<K, V>>(new StructuredId(id), StateSpecs.multimap(keyCoder, valueCoder));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized OrderedListState<T>> orderedList(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new SimpleStateTag<OrderedListState<T>>(new StructuredId(id), StateSpecs.orderedList(elemCoder));
    }

    public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> watermarkStateInternal(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
        return new SimpleStateTag<WatermarkHoldState>(new StructuredId(id), StateSpecs.watermarkStateInternal(timestampCombiner));
    }

    public static <StateT extends State> @UnknownKeyFor @NonNull @Initialized StateTag<StateT> makeSystemTagInternal(@UnknownKeyFor @NonNull @Initialized StateTag<StateT> tag) {
        if (!(tag instanceof SystemStateTag)) {
            throw new IllegalArgumentException("Expected subclass of SimpleStateTag, got " + tag);
        }
        SystemStateTag typedTag = (SystemStateTag)((Object)tag);
        return typedTag.asKind(StateKind.SYSTEM);
    }

    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<AccumT>> convertToBagTagInternal(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningTag) {
        return new SimpleStateTag<BagState<AccumT>>(new StructuredId(combiningTag.getId()), StateSpecs.convertToBagSpecInternal(combiningTag.getSpec()));
    }

    public static <KeyT> @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, @UnknownKeyFor @NonNull @Initialized Boolean>> convertToMapTagInternal(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized SetState<KeyT>> setTag) {
        return new SimpleStateTag<MapState<KeyT, Boolean>>(new StructuredId(setTag.getId()), StateSpecs.convertToMapSpecInternal(setTag.getSpec()));
    }

    private static class SimpleStateTag<@UnknownKeyFor StateT extends @UnknownKeyFor @NonNull @Initialized State>
    implements StateTag<StateT>,
    SystemStateTag<StateT> {
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<StateT> spec;
        private final @UnknownKeyFor @NonNull @Initialized StructuredId id;

        public SimpleStateTag(@UnknownKeyFor @NonNull @Initialized StructuredId id, @UnknownKeyFor @NonNull @Initialized StateSpec<StateT> spec) {
            this.id = id;
            this.spec = spec;
        }

        @Override
        @Deprecated
        public StateT bind(@UnknownKeyFor @NonNull @Initialized StateTag.StateBinder binder) {
            return this.spec.bind(this.id.getRawId(), StateTags.adaptTagBinder(binder));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getId() {
            return this.id.getRawId();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StateSpec<StateT> getSpec() {
            return this.spec;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).toString();
        }

        @Override
        public void appendTo(@UnknownKeyFor @NonNull @Initialized Appendable sb) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.id.appendTo(sb);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StateTag<StateT> asKind(@UnknownKeyFor @NonNull @Initialized StateKind kind) {
            return new SimpleStateTag<StateT>(this.id.asKind(kind), this.spec);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof SimpleStateTag)) {
                return false;
            }
            SimpleStateTag otherTag = (SimpleStateTag)other;
            return Objects.equals(this.getId(), otherTag.getId());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.getId());
        }
    }

    private static class StructuredId
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized StateKind kind;
        private final @UnknownKeyFor @NonNull @Initialized String rawId;

        private StructuredId(@UnknownKeyFor @NonNull @Initialized String rawId) {
            this(StateKind.USER, rawId);
        }

        private StructuredId(@UnknownKeyFor @NonNull @Initialized StateKind kind, @UnknownKeyFor @NonNull @Initialized String rawId) {
            this.kind = kind;
            this.rawId = rawId;
        }

        public @UnknownKeyFor @NonNull @Initialized StructuredId asKind(@UnknownKeyFor @NonNull @Initialized StateKind kind) {
            return new StructuredId(kind, this.rawId);
        }

        public void appendTo(@UnknownKeyFor @NonNull @Initialized Appendable sb) throws @UnknownKeyFor @NonNull @Initialized IOException {
            sb.append(this.kind.prefix).append(this.rawId);
        }

        public @UnknownKeyFor @NonNull @Initialized String getRawId() {
            return this.rawId;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.rawId).add("kind", (Object)this.kind).toString();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StructuredId)) {
                return false;
            }
            StructuredId that = (StructuredId)obj;
            return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.rawId, that.rawId);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.rawId});
        }
    }

    private static interface SystemStateTag<@UnknownKeyFor StateT extends @UnknownKeyFor @NonNull @Initialized State> {
        public @UnknownKeyFor @NonNull @Initialized StateTag<StateT> asKind(@UnknownKeyFor @NonNull @Initialized StateKind var1);
    }

    private static enum StateKind {
        SYSTEM('s'),
        USER('u');

        private final @UnknownKeyFor @NonNull @Initialized char prefix;

        private StateKind(char prefix) {
            this.prefix = prefix;
        }
    }
}

