/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.data;

import java.util.Collections;
import java.util.List;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.BeamFnDataSizeBasedBufferingOutboundObserver;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.BeamFnDataTimeBasedBufferingOutboundObserver;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.repackaged.direct_java.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

public interface BeamFnDataBufferingOutboundObserver<T>
extends CloseableFnDataReceiver<T> {
    @Deprecated
    public static final String BEAM_FN_API_DATA_BUFFER_LIMIT = "beam_fn_api_data_buffer_limit=";
    @Deprecated
    public static final String BEAM_FN_API_DATA_BUFFER_SIZE_LIMIT = "beam_fn_api_data_buffer_size_limit=";
    public static final String DATA_BUFFER_SIZE_LIMIT = "data_buffer_size_limit=";
    @VisibleForTesting
    public static final int DEFAULT_BUFFER_LIMIT_BYTES = 1000000;
    @Deprecated
    public static final String BEAM_FN_API_DATA_BUFFER_TIME_LIMIT = "beam_fn_api_data_buffer_time_limit=";
    public static final String DATA_BUFFER_TIME_LIMIT_MS = "data_buffer_time_limit_ms=";
    public static final long DEFAULT_BUFFER_LIMIT_TIME_MS = -1L;

    public static <T> BeamFnDataSizeBasedBufferingOutboundObserver<T> forLocation(PipelineOptions options, LogicalEndpoint endpoint, Coder<T> coder, StreamObserver<BeamFnApi.Elements> outboundObserver) {
        int sizeLimit = BeamFnDataBufferingOutboundObserver.getSizeLimit(options);
        long timeLimit = BeamFnDataBufferingOutboundObserver.getTimeLimit(options);
        if (timeLimit > 0L) {
            return new BeamFnDataTimeBasedBufferingOutboundObserver<T>(sizeLimit, timeLimit, endpoint, coder, outboundObserver);
        }
        return new BeamFnDataSizeBasedBufferingOutboundObserver<T>(sizeLimit, endpoint, coder, outboundObserver);
    }

    public static int getSizeLimit(PipelineOptions options) {
        List experiments = ((ExperimentalOptions)options.as(ExperimentalOptions.class)).getExperiments();
        for (String experiment : experiments == null ? Collections.emptyList() : experiments) {
            if (experiment.startsWith(DATA_BUFFER_SIZE_LIMIT)) {
                return Integer.parseInt(experiment.substring(DATA_BUFFER_SIZE_LIMIT.length()));
            }
            if (experiment.startsWith(BEAM_FN_API_DATA_BUFFER_SIZE_LIMIT)) {
                return Integer.parseInt(experiment.substring(BEAM_FN_API_DATA_BUFFER_SIZE_LIMIT.length()));
            }
            if (!experiment.startsWith(BEAM_FN_API_DATA_BUFFER_LIMIT)) continue;
            return Integer.parseInt(experiment.substring(BEAM_FN_API_DATA_BUFFER_LIMIT.length()));
        }
        return 1000000;
    }

    public static long getTimeLimit(PipelineOptions options) {
        List experiments = ((ExperimentalOptions)options.as(ExperimentalOptions.class)).getExperiments();
        for (String experiment : experiments == null ? Collections.emptyList() : experiments) {
            if (experiment.startsWith(DATA_BUFFER_TIME_LIMIT_MS)) {
                return Long.parseLong(experiment.substring(DATA_BUFFER_TIME_LIMIT_MS.length()));
            }
            if (!experiment.startsWith(BEAM_FN_API_DATA_BUFFER_TIME_LIMIT)) continue;
            return Long.parseLong(experiment.substring(BEAM_FN_API_DATA_BUFFER_TIME_LIMIT.length()));
        }
        return -1L;
    }
}

