/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.joda.time.Duration;

interface UnboundedReadDeduplicator {
    public boolean shouldOutput(byte[] var1);

    public static class CachedIdDeduplicator
    implements UnboundedReadDeduplicator {
        private static final ByteArrayCoder RECORD_ID_CODER = ByteArrayCoder.of();
        private static final long MAX_RETENTION_SINCE_ACCESS = Duration.standardMinutes((long)10L).getMillis();
        private final LoadingCache<StructuralKey<byte[]>, AtomicBoolean> ids = CacheBuilder.newBuilder().expireAfterAccess(MAX_RETENTION_SINCE_ACCESS, TimeUnit.MILLISECONDS).maximumSize(100000L).build((CacheLoader)new TrueBooleanLoader());

        public static UnboundedReadDeduplicator create() {
            return new CachedIdDeduplicator();
        }

        private CachedIdDeduplicator() {
        }

        @Override
        public boolean shouldOutput(byte[] recordId) {
            return ((AtomicBoolean)this.ids.getUnchecked(StructuralKey.of(recordId, RECORD_ID_CODER))).getAndSet(false);
        }

        private static class TrueBooleanLoader
        extends CacheLoader<StructuralKey<byte[]>, AtomicBoolean> {
            private TrueBooleanLoader() {
            }

            public AtomicBoolean load(StructuralKey<byte[]> key) throws Exception {
                return new AtomicBoolean(true);
            }
        }
    }

    public static class NeverDeduplicator
    implements UnboundedReadDeduplicator {
        public static UnboundedReadDeduplicator create() {
            return new NeverDeduplicator();
        }

        @Override
        public boolean shouldOutput(byte[] recordId) {
            return true;
        }
    }
}

