/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.wire;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SyntheticComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.wire.LengthPrefixUnknownCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class WireCoders {
    public static String addSdkWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components.Builder components, RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) {
        return WireCoders.addWireCoder(pCollectionNode, components, false, wireCoderSetting);
    }

    public static String addRunnerWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components.Builder components, RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) {
        return WireCoders.addWireCoder(pCollectionNode, components, true, wireCoderSetting);
    }

    public static <T> Coder<WindowedValue<T>> instantiateRunnerWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components components) throws IOException {
        return WireCoders.instantiateRunnerWireCoder(pCollectionNode, components, RunnerApi.ExecutableStagePayload.WireCoderSetting.getDefaultInstance());
    }

    public static <T> Coder<WindowedValue<T>> instantiateRunnerWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components components, RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) throws IOException {
        RunnerApi.Components.Builder builder = components.toBuilder();
        String protoCoderId = WireCoders.addRunnerWireCoder(pCollectionNode, builder, wireCoderSetting);
        Coder<?> javaCoder = RehydratedComponents.forComponents(builder.build()).getCoder(protoCoderId);
        Preconditions.checkArgument((boolean)(javaCoder instanceof WindowedValue.FullWindowedValueCoder), (String)"Unexpected Deserialized %s type, expected %s, got %s", (Object)RunnerApi.Coder.class.getSimpleName(), (Object)WindowedValue.FullWindowedValueCoder.class.getSimpleName(), javaCoder.getClass());
        return javaCoder;
    }

    private static String addWireCoder(PipelineNode.PCollectionNode pCollectionNode, RunnerApi.Components.Builder components, boolean useByteArrayCoder, RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) {
        RunnerApi.Coder windowedValueCoder;
        String elementCoderId = pCollectionNode.getPCollection().getCoderId();
        String windowingStrategyId = pCollectionNode.getPCollection().getWindowingStrategyId();
        String windowCoderId = components.getWindowingStrategiesOrThrow(windowingStrategyId).getWindowCoderId();
        String wireCoderUrn = wireCoderSetting.getUrn();
        if (wireCoderUrn.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE)) || wireCoderUrn.isEmpty()) {
            windowedValueCoder = ModelCoders.windowedValueCoder(elementCoderId, windowCoderId);
        } else {
            Preconditions.checkArgument((boolean)wireCoderUrn.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE)), (String)"Unexpected wire coder urn %s, currently only %s or %s are supported!", (Object)wireCoderUrn, (Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE), (Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE));
            windowedValueCoder = ModelCoders.paramWindowedValueCoder(elementCoderId, windowCoderId, wireCoderSetting.getPayload().toByteArray());
        }
        String windowedValueId = SyntheticComponents.uniqueId(String.format("fn/wire/%s", pCollectionNode.getId()), arg_0 -> ((RunnerApi.Components.Builder)components).containsCoders(arg_0));
        components.putCoders(windowedValueId, windowedValueCoder);
        return LengthPrefixUnknownCoders.addLengthPrefixedCoder(windowedValueId, components, useByteArrayCoder);
    }

    private WireCoders() {
    }
}

