/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Equivalence;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StateTags {
    private static final CoderRegistry STANDARD_REGISTRY = CoderRegistry.createDefault();
    public static final Equivalence<StateTag> ID_EQUIVALENCE = new Equivalence<StateTag>(){

        protected boolean doEquivalent(StateTag a, StateTag b) {
            return a.getId().equals(b.getId());
        }

        protected int doHash(StateTag stateTag) {
            return stateTag.getId().hashCode();
        }
    };

    @Deprecated
    private static StateBinder adaptTagBinder(final StateTag.StateBinder binder) {
        return new StateBinder(){

            public <T> ValueState<T> bindValue(String id, StateSpec<ValueState<T>> spec, Coder<T> coder) {
                return binder.bindValue(StateTags.tagForSpec(id, spec), coder);
            }

            public <T> BagState<T> bindBag(String id, StateSpec<BagState<T>> spec, Coder<T> elemCoder) {
                return binder.bindBag(StateTags.tagForSpec(id, spec), elemCoder);
            }

            public <T> SetState<T> bindSet(String id, StateSpec<SetState<T>> spec, Coder<T> elemCoder) {
                return binder.bindSet(StateTags.tagForSpec(id, spec), elemCoder);
            }

            public <KeyT, ValueT> MapState<KeyT, ValueT> bindMap(String id, StateSpec<MapState<KeyT, ValueT>> spec, Coder<KeyT> mapKeyCoder, Coder<ValueT> mapValueCoder) {
                return binder.bindMap(StateTags.tagForSpec(id, spec), mapKeyCoder, mapValueCoder);
            }

            public <T> OrderedListState<T> bindOrderedList(String id, StateSpec<OrderedListState<T>> spec, Coder<T> elemCoder) {
                return binder.bindOrderedList(StateTags.tagForSpec(id, spec), elemCoder);
            }

            public <InputT, AccumT, OutputT> CombiningState<InputT, AccumT, OutputT> bindCombining(String id, StateSpec<CombiningState<InputT, AccumT, OutputT>> spec, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
                return binder.bindCombiningValue(StateTags.tagForSpec(id, spec), accumCoder, combineFn);
            }

            public <InputT, AccumT, OutputT> CombiningState<InputT, AccumT, OutputT> bindCombiningWithContext(String id, StateSpec<CombiningState<InputT, AccumT, OutputT>> spec, Coder<AccumT> accumCoder, CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
                return binder.bindCombiningValueWithContext(StateTags.tagForSpec(id, spec), accumCoder, combineFn);
            }

            public WatermarkHoldState bindWatermark(String id, StateSpec<WatermarkHoldState> spec, TimestampCombiner timestampCombiner) {
                return binder.bindWatermark(StateTags.tagForSpec(id, spec), timestampCombiner);
            }
        };
    }

    private StateTags() {
    }

    public static <StateT extends State> StateTag<StateT> tagForSpec(String id, StateSpec<StateT> spec) {
        return new SimpleStateTag<StateT>(new StructuredId(id), spec);
    }

    public static <T> StateTag<ValueState<T>> value(String id, Coder<T> valueCoder) {
        return new SimpleStateTag<ValueState<T>>(new StructuredId(id), StateSpecs.value(valueCoder));
    }

    public static <InputT, AccumT, OutputT> StateTag<CombiningState<InputT, AccumT, OutputT>> combiningValue(String id, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new SimpleStateTag<CombiningState<InputT, AccumT, OutputT>>(new StructuredId(id), StateSpecs.combining(accumCoder, combineFn));
    }

    public static <InputT, AccumT, OutputT> StateTag<CombiningState<InputT, AccumT, OutputT>> combiningValueWithContext(String id, Coder<AccumT> accumCoder, CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return new SimpleStateTag<CombiningState<InputT, AccumT, OutputT>>(new StructuredId(id), StateSpecs.combining(accumCoder, combineFn));
    }

    public static <InputT, AccumT, OutputT> StateTag<CombiningState<InputT, AccumT, OutputT>> combiningValueFromInputInternal(String id, Coder<InputT> inputCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new SimpleStateTag<CombiningState<InputT, AccumT, OutputT>>(new StructuredId(id), StateSpecs.combiningFromInputInternal(inputCoder, combineFn));
    }

    public static <T> StateTag<BagState<T>> bag(String id, Coder<T> elemCoder) {
        return new SimpleStateTag<BagState<T>>(new StructuredId(id), StateSpecs.bag(elemCoder));
    }

    public static <T> StateTag<SetState<T>> set(String id, Coder<T> elemCoder) {
        return new SimpleStateTag<SetState<T>>(new StructuredId(id), StateSpecs.set(elemCoder));
    }

    public static <K, V> StateTag<MapState<K, V>> map(String id, Coder<K> keyCoder, Coder<V> valueCoder) {
        return new SimpleStateTag<MapState<K, V>>(new StructuredId(id), StateSpecs.map(keyCoder, valueCoder));
    }

    public static <T> StateTag<OrderedListState<T>> orderedList(String id, Coder<T> elemCoder) {
        return new SimpleStateTag<OrderedListState<T>>(new StructuredId(id), StateSpecs.orderedList(elemCoder));
    }

    public static <W extends BoundedWindow> StateTag<WatermarkHoldState> watermarkStateInternal(String id, TimestampCombiner timestampCombiner) {
        return new SimpleStateTag<WatermarkHoldState>(new StructuredId(id), StateSpecs.watermarkStateInternal((TimestampCombiner)timestampCombiner));
    }

    public static <StateT extends State> StateTag<StateT> makeSystemTagInternal(StateTag<StateT> tag) {
        if (!(tag instanceof SystemStateTag)) {
            throw new IllegalArgumentException("Expected subclass of SimpleStateTag, got " + tag);
        }
        SystemStateTag typedTag = (SystemStateTag)((Object)tag);
        return typedTag.asKind(StateKind.SYSTEM);
    }

    public static <InputT, AccumT, OutputT> StateTag<BagState<AccumT>> convertToBagTagInternal(StateTag<CombiningState<InputT, AccumT, OutputT>> combiningTag) {
        return new SimpleStateTag<BagState<AccumT>>(new StructuredId(combiningTag.getId()), StateSpecs.convertToBagSpecInternal(combiningTag.getSpec()));
    }

    public static <KeyT> StateTag<MapState<KeyT, Boolean>> convertToMapTagInternal(StateTag<SetState<KeyT>> setTag) {
        return new SimpleStateTag<MapState<KeyT, Boolean>>(new StructuredId(setTag.getId()), StateSpecs.convertToMapSpecInternal(setTag.getSpec()));
    }

    private static class SimpleStateTag<StateT extends State>
    implements StateTag<StateT>,
    SystemStateTag<StateT> {
        private final StateSpec<StateT> spec;
        private final StructuredId id;

        public SimpleStateTag(StructuredId id, StateSpec<StateT> spec) {
            this.id = id;
            this.spec = spec;
        }

        @Override
        @Deprecated
        public StateT bind(StateTag.StateBinder binder) {
            return (StateT)this.spec.bind(this.id.getRawId(), StateTags.adaptTagBinder(binder));
        }

        @Override
        public String getId() {
            return this.id.getRawId();
        }

        @Override
        public StateSpec<StateT> getSpec() {
            return this.spec;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).toString();
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            this.id.appendTo(sb);
        }

        @Override
        public StateTag<StateT> asKind(StateKind kind) {
            return new SimpleStateTag<StateT>(this.id.asKind(kind), this.spec);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof SimpleStateTag)) {
                return false;
            }
            SimpleStateTag otherTag = (SimpleStateTag)other;
            return Objects.equals(this.getId(), otherTag.getId());
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.getId());
        }
    }

    private static class StructuredId
    implements Serializable {
        private final StateKind kind;
        private final String rawId;

        private StructuredId(String rawId) {
            this(StateKind.USER, rawId);
        }

        private StructuredId(StateKind kind, String rawId) {
            this.kind = kind;
            this.rawId = rawId;
        }

        public StructuredId asKind(StateKind kind) {
            return new StructuredId(kind, this.rawId);
        }

        public void appendTo(Appendable sb) throws IOException {
            sb.append(this.kind.prefix).append(this.rawId);
        }

        public String getRawId() {
            return this.rawId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.rawId).add("kind", (Object)this.kind).toString();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StructuredId)) {
                return false;
            }
            StructuredId that = (StructuredId)obj;
            return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.rawId, that.rawId);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.rawId});
        }
    }

    private static interface SystemStateTag<StateT extends State> {
        public StateTag<StateT> asKind(StateKind var1);
    }

    private static enum StateKind {
        SYSTEM('s'),
        USER('u');

        private final char prefix;

        private StateKind(char prefix) {
            this.prefix = prefix;
        }
    }
}

