/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EmptyInputProvider;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ImpulseEvaluatorFactory;
import org.apache.beam.runners.direct.ReadEvaluatorFactory;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class RootProviderRegistry {
    private final Map<String, RootInputProvider<?, ?, ?>> providers;

    public static RootProviderRegistry javaNativeRegistry(EvaluationContext context, PipelineOptions options) {
        return new RootProviderRegistry((Map<String, RootInputProvider<?, ?, ?>>)ImmutableMap.builder().put((Object)"beam:transform:impulse:v1", (Object)new ImpulseEvaluatorFactory.ImpulseRootProvider(context)).put((Object)"beam:transform:read:v1", ReadEvaluatorFactory.inputProvider(context, options)).put((Object)"beam:directrunner:transforms:test_stream:v1", new TestStreamEvaluatorFactory.InputProvider(context)).put((Object)"beam:transform:flatten:v1", new EmptyInputProvider()).build());
    }

    public static RootProviderRegistry impulseRegistry(EvaluationContext context) {
        return new RootProviderRegistry((Map<String, RootInputProvider<?, ?, ?>>)ImmutableMap.builder().put((Object)"beam:transform:impulse:v1", (Object)new ImpulseEvaluatorFactory.ImpulseRootProvider(context)).build());
    }

    private RootProviderRegistry(Map<String, RootInputProvider<?, ?, ?>> providers) {
        this.providers = providers;
    }

    public Collection<CommittedBundle<?>> getInitialInputs(AppliedPTransform<?, ?, ?> transform, int targetParallelism) throws Exception {
        String transformUrn = PTransformTranslation.urnForTransform(transform.getTransform());
        RootInputProvider provider = (RootInputProvider)Preconditions.checkNotNull(this.providers.get(transformUrn), (String)"Tried to get a %s for a transform \"%s\", but there is no such provider", (Object)RootInputProvider.class.getSimpleName(), (Object)transformUrn);
        return provider.getInitialInputs(transform, targetParallelism);
    }
}

