/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.Arrays;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

class OrFinallyStateMachine
extends TriggerStateMachine {
    private static final int ACTUAL = 0;
    private static final int UNTIL = 1;

    @VisibleForTesting
    OrFinallyStateMachine(TriggerStateMachine actual, TriggerStateMachine until) {
        super(Arrays.asList(actual, until));
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        c.trigger().subTrigger(0).invokeOnElement(c);
        c.trigger().subTrigger(1).invokeOnElement(c);
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnMerge(c);
        }
        this.updateFinishedState(c);
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        return context.trigger().subTrigger(0).invokeShouldFire(context) || context.trigger().subTrigger(1).invokeShouldFire(context);
    }

    @Override
    public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
        ExecutableTriggerStateMachine actualSubtrigger = context.trigger().subTrigger(0);
        ExecutableTriggerStateMachine untilSubtrigger = context.trigger().subTrigger(1);
        if (untilSubtrigger.invokeShouldFire(context)) {
            untilSubtrigger.invokeOnFire(context);
            actualSubtrigger.invokeClear(context);
        } else {
            actualSubtrigger.invokeOnFire(context);
        }
        this.updateFinishedState(context);
    }

    @Override
    public String toString() {
        return String.format("%s.orFinally(%s)", this.subTriggers.get(0), this.subTriggers.get(1));
    }

    private void updateFinishedState(TriggerStateMachine.TriggerContext c) throws Exception {
        boolean anyStillFinished = false;
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            anyStillFinished |= c.forTrigger(subTrigger).trigger().isFinished();
        }
        c.trigger().setFinished(anyStillFinished);
    }
}

