/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.External;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class ExternalTranslation {
    public static final String EXTERNAL_TRANSFORM_URN = "beam:transform:external:v1";

    public static class ExternalTranslator
    implements PTransformTranslation.TransformTranslator<External.ExpandableTransform<?, ?>> {
        public static PTransformTranslation.TransformTranslator create() {
            return new ExternalTranslator();
        }

        @Override
        @Nullable
        public String getUrn(External.ExpandableTransform transform) {
            return ExternalTranslation.EXTERNAL_TRANSFORM_URN;
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return pTransform instanceof External.ExpandableTransform;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            Preconditions.checkArgument((boolean)this.canTranslate(appliedPTransform.getTransform()), (Object)"can only translate ExpandableTransform");
            External.ExpandableTransform expandableTransform = (External.ExpandableTransform)appliedPTransform.getTransform();
            String nameSpace = expandableTransform.getNamespace();
            String impulsePrefix = expandableTransform.getImpulsePrefix();
            RunnerApi.PTransform expandedTransform = expandableTransform.getExpandedTransform();
            RunnerApi.Components expandedComponents = expandableTransform.getExpandedComponents();
            Map<PCollection, String> externalPCollectionIdMap = expandableTransform.getExternalPCollectionIdMap();
            Map<Coder, String> externalCoderIdMap = expandableTransform.getExternalCoderIdMap();
            ImmutableMap.Builder pColRenameMapBuilder = ImmutableMap.builder();
            for (Map.Entry<PCollection, String> entry : externalPCollectionIdMap.entrySet()) {
                pColRenameMapBuilder.put((Object)entry.getValue(), (Object)components.registerPCollection(entry.getKey()));
            }
            ImmutableMap pColRenameMap = pColRenameMapBuilder.build();
            ImmutableMap.Builder coderRenameMapBuilder = ImmutableMap.builder();
            for (Map.Entry<Coder, String> entry : externalCoderIdMap.entrySet()) {
                coderRenameMapBuilder.put((Object)entry.getValue(), (Object)components.registerCoder(entry.getKey()));
            }
            ImmutableMap coderRenameMap = coderRenameMapBuilder.build();
            RunnerApi.Components.Builder mergingComponentsBuilder = RunnerApi.Components.newBuilder();
            for (Map.Entry entry : expandedComponents.getCodersMap().entrySet()) {
                if (!((String)entry.getKey()).startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putCoders((String)entry.getKey(), (RunnerApi.Coder)entry.getValue());
            }
            for (Map.Entry entry : expandedComponents.getWindowingStrategiesMap().entrySet()) {
                if (!((String)entry.getKey()).startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putWindowingStrategies((String)entry.getKey(), (RunnerApi.WindowingStrategy)entry.getValue());
            }
            for (Map.Entry entry : expandedComponents.getEnvironmentsMap().entrySet()) {
                if (!((String)entry.getKey()).startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putEnvironments((String)entry.getKey(), (RunnerApi.Environment)entry.getValue());
            }
            for (Map.Entry entry : expandedComponents.getPcollectionsMap().entrySet()) {
                if (!((String)entry.getKey()).startsWith(nameSpace)) continue;
                String coderId = ((RunnerApi.PCollection)entry.getValue()).getCoderId();
                mergingComponentsBuilder.putPcollections((String)entry.getKey(), ((RunnerApi.PCollection)entry.getValue()).toBuilder().setCoderId((String)coderRenameMap.getOrDefault((Object)coderId, (Object)coderId)).build());
            }
            for (Map.Entry entry : expandedComponents.getTransformsMap().entrySet()) {
                if (((String)entry.getKey()).startsWith(impulsePrefix)) continue;
                Preconditions.checkState((boolean)((String)entry.getKey()).startsWith(nameSpace), (Object)"unknown transform found");
                RunnerApi.PTransform proto = (RunnerApi.PTransform)entry.getValue();
                RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
                transformBuilder.setUniqueName(proto.getUniqueName()).setSpec(proto.getSpec()).setEnvironmentId(proto.getEnvironmentId()).addAllSubtransforms((Iterable)proto.getSubtransformsList());
                for (Map.Entry inputEntry : proto.getInputsMap().entrySet()) {
                    transformBuilder.putInputs((String)inputEntry.getKey(), (String)pColRenameMap.getOrDefault(inputEntry.getValue(), (Object)((String)inputEntry.getValue())));
                }
                for (Map.Entry outputEntry : proto.getOutputsMap().entrySet()) {
                    transformBuilder.putOutputs((String)outputEntry.getKey(), (String)pColRenameMap.getOrDefault(outputEntry.getValue(), (Object)((String)outputEntry.getValue())));
                }
                mergingComponentsBuilder.putTransforms((String)entry.getKey(), transformBuilder.build());
            }
            RunnerApi.PTransform.Builder rootTransformBuilder = RunnerApi.PTransform.newBuilder();
            rootTransformBuilder.setUniqueName(expandedTransform.getUniqueName()).setSpec(expandedTransform.getSpec()).addAllSubtransforms((Iterable)expandedTransform.getSubtransformsList()).setEnvironmentId(expandedTransform.getEnvironmentId()).putAllInputs(expandedTransform.getInputsMap());
            for (Map.Entry outputEntry : expandedTransform.getOutputsMap().entrySet()) {
                rootTransformBuilder.putOutputs((String)outputEntry.getKey(), (String)pColRenameMap.getOrDefault(outputEntry.getValue(), (Object)((String)outputEntry.getValue())));
            }
            components.mergeFrom(mergingComponentsBuilder.build(), null);
            return rootTransformBuilder.build();
        }
    }
}

