/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.BeamUrns;
import org.apache.beam.repackaged.direct_java.runners.core.construction.DefaultArtifactResolver;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environments {
    private static final Logger LOG = LoggerFactory.getLogger(Environments.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    public static final String ENVIRONMENT_DOCKER = "DOCKER";
    public static final String ENVIRONMENT_PROCESS = "PROCESS";
    public static final String ENVIRONMENT_EXTERNAL = "EXTERNAL";
    public static final String ENVIRONMENT_EMBEDDED = "EMBEDDED";
    public static final String ENVIRONMENT_LOOPBACK = "LOOPBACK";
    private static final String JAVA_SDK_HARNESS_CONTAINER_URL = ReleaseInfo.getReleaseInfo().getDefaultDockerRepoRoot() + "/" + ReleaseInfo.getReleaseInfo().getDefaultDockerRepoPrefix() + "java_sdk:" + ReleaseInfo.getReleaseInfo().getSdkVersion();
    public static final RunnerApi.Environment JAVA_SDK_HARNESS_ENVIRONMENT = Environments.createDockerEnvironment(JAVA_SDK_HARNESS_CONTAINER_URL);

    private Environments() {
    }

    public static RunnerApi.Environment createOrGetDefaultEnvironment(PortablePipelineOptions options) {
        RunnerApi.Environment defaultEnvironment;
        String type = options.getDefaultEnvironmentType();
        String config = options.getDefaultEnvironmentConfig();
        if (Strings.isNullOrEmpty((String)type)) {
            defaultEnvironment = JAVA_SDK_HARNESS_ENVIRONMENT;
        } else {
            switch (type) {
                case "EMBEDDED": {
                    defaultEnvironment = Environments.createEmbeddedEnvironment(config);
                    break;
                }
                case "EXTERNAL": 
                case "LOOPBACK": {
                    defaultEnvironment = Environments.createExternalEnvironment(config);
                    break;
                }
                case "PROCESS": {
                    defaultEnvironment = Environments.createProcessEnvironment(config);
                    break;
                }
                default: {
                    defaultEnvironment = Environments.createDockerEnvironment(config);
                }
            }
        }
        return defaultEnvironment.toBuilder().addAllDependencies(Environments.getDeferredArtifacts((PipelineOptions)options)).addAllCapabilities(Environments.getJavaCapabilities()).build();
    }

    public static RunnerApi.Environment createDockerEnvironment(String dockerImageUrl) {
        if (Strings.isNullOrEmpty((String)dockerImageUrl)) {
            return JAVA_SDK_HARNESS_ENVIRONMENT;
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)).setPayload(RunnerApi.DockerPayload.newBuilder().setContainerImage(dockerImageUrl).build().toByteString()).build();
    }

    private static RunnerApi.Environment createExternalEnvironment(String config) {
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.EXTERNAL)).setPayload(RunnerApi.ExternalPayload.newBuilder().setEndpoint(Endpoints.ApiServiceDescriptor.newBuilder().setUrl(config).build()).build().toByteString()).build();
    }

    private static RunnerApi.Environment createProcessEnvironment(String config) {
        try {
            ProcessPayloadReferenceJSON payloadReferenceJSON = (ProcessPayloadReferenceJSON)MAPPER.readValue(config, ProcessPayloadReferenceJSON.class);
            return Environments.createProcessEnvironment(payloadReferenceJSON.getOs(), payloadReferenceJSON.getArch(), payloadReferenceJSON.getCommand(), payloadReferenceJSON.getEnv());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to parse process environment config: %s", config), e);
        }
    }

    private static RunnerApi.Environment createEmbeddedEnvironment(String config) {
        return RunnerApi.Environment.newBuilder().setUrn(ENVIRONMENT_EMBEDDED).setPayload(ByteString.copyFromUtf8((String)((String)MoreObjects.firstNonNull((Object)config, (Object)"")))).build();
    }

    public static RunnerApi.Environment createProcessEnvironment(String os, String arch, String command, Map<String, String> env) {
        RunnerApi.ProcessPayload.Builder builder = RunnerApi.ProcessPayload.newBuilder();
        if (!Strings.isNullOrEmpty((String)os)) {
            builder.setOs(os);
        }
        if (!Strings.isNullOrEmpty((String)arch)) {
            builder.setArch(arch);
        }
        if (!Strings.isNullOrEmpty((String)command)) {
            builder.setCommand(command);
        }
        if (env != null) {
            builder.putAllEnv(env);
        }
        return RunnerApi.Environment.newBuilder().setUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.PROCESS)).setPayload(builder.build().toByteString()).build();
    }

    public static Optional<RunnerApi.Environment> getEnvironment(String ptransformId, RunnerApi.Components components) {
        RunnerApi.PTransform ptransform = components.getTransformsOrThrow(ptransformId);
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironmentsOrThrow(envId));
    }

    public static Optional<RunnerApi.Environment> getEnvironment(RunnerApi.PTransform ptransform, RehydratedComponents components) {
        String envId = ptransform.getEnvironmentId();
        if (Strings.isNullOrEmpty((String)envId)) {
            return Optional.empty();
        }
        return Optional.of(components.getEnvironment(envId));
    }

    public static List<RunnerApi.ArtifactInformation> getArtifacts(List<String> stagingFiles) {
        ImmutableList.Builder artifactsBuilder = ImmutableList.builder();
        LinkedHashSet<String> deduplicatedStagingFiles = new LinkedHashSet<String>(stagingFiles);
        for (String path : deduplicatedStagingFiles) {
            HashCode hashCode;
            File file;
            String stagedName = null;
            if (path.contains("=")) {
                String[] components = path.split("=", 2);
                file = new File(components[1]);
                stagedName = components[0];
            } else {
                file = new File(path);
            }
            if (!file.exists()) continue;
            RunnerApi.ArtifactInformation.Builder artifactBuilder = RunnerApi.ArtifactInformation.newBuilder();
            artifactBuilder.setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.FILE));
            artifactBuilder.setRoleUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Roles.STAGING_TO));
            if (file.isDirectory()) {
                File zippedFile;
                try {
                    zippedFile = Environments.zipDirectory(file);
                    hashCode = Files.asByteSource((File)zippedFile).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(zippedFile.getPath()).setSha256(hashCode.toString()).build().toByteString());
            } else {
                try {
                    hashCode = Files.asByteSource((File)file).hash(Hashing.sha256());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                artifactBuilder.setTypePayload(RunnerApi.ArtifactFilePayload.newBuilder().setPath(file.getPath()).setSha256(hashCode.toString()).build().toByteString());
            }
            if (stagedName == null) {
                stagedName = Environments.createStagingFileName(file, hashCode);
            }
            artifactBuilder.setRolePayload(RunnerApi.ArtifactStagingToRolePayload.newBuilder().setStagedName(stagedName).build().toByteString());
            artifactsBuilder.add((Object)artifactBuilder.build());
        }
        return artifactsBuilder.build();
    }

    public static List<RunnerApi.ArtifactInformation> getDeferredArtifacts(PipelineOptions options) {
        List stagingFiles = ((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).getFilesToStage();
        if (stagingFiles == null || stagingFiles.isEmpty()) {
            return ImmutableList.of();
        }
        String key = UUID.randomUUID().toString();
        DefaultArtifactResolver.INSTANCE.register(info -> {
            if (BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.DEFERRED).equals(info.getTypeUrn())) {
                RunnerApi.DeferredArtifactPayload deferredArtifactPayload;
                try {
                    deferredArtifactPayload = RunnerApi.DeferredArtifactPayload.parseFrom((ByteString)info.getTypePayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Error parsing deferred artifact payload.", e);
                }
                if (key.equals(deferredArtifactPayload.getKey())) {
                    return Optional.of(Environments.getArtifacts(stagingFiles));
                }
                return Optional.empty();
            }
            return Optional.empty();
        });
        return ImmutableList.of((Object)RunnerApi.ArtifactInformation.newBuilder().setTypeUrn(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardArtifacts.Types.DEFERRED)).setTypePayload(RunnerApi.DeferredArtifactPayload.newBuilder().setKey(key).build().toByteString()).build());
    }

    public static Set<String> getJavaCapabilities() {
        ImmutableSet.Builder capabilities = ImmutableSet.builder();
        capabilities.addAll(ModelCoders.urns());
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardProtocols.Enum.MULTI_CORE_BUNDLE_PROCESSING));
        capabilities.add((Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardProtocols.Enum.PROGRESS_REPORTING));
        capabilities.add((Object)("beam:version:sdk_base:" + JAVA_SDK_HARNESS_CONTAINER_URL));
        return capabilities.build();
    }

    public static String createStagingFileName(File path, HashCode hash) {
        String encodedHash = Base64Variants.MODIFIED_FOR_URL.encode(hash.asBytes());
        String fileName = Files.getNameWithoutExtension((String)path.getAbsolutePath());
        String ext = path.isDirectory() ? "jar" : Files.getFileExtension((String)path.getAbsolutePath());
        String suffix = Strings.isNullOrEmpty((String)ext) ? "" : "." + ext;
        return String.format("%s-%s%s", fileName, encodedHash, suffix);
    }

    private static File zipDirectory(File directory) throws IOException {
        File zipFile = File.createTempFile(directory.getName(), ".zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            ZipFiles.zipDirectory((File)directory, (OutputStream)fos);
        }
        return zipFile;
    }

    private static class ProcessPayloadReferenceJSON {
        @Nullable
        private String os;
        @Nullable
        private String arch;
        @Nullable
        private String command;
        @Nullable
        private Map<String, String> env;

        private ProcessPayloadReferenceJSON() {
        }

        @Nullable
        public String getOs() {
            return this.os;
        }

        @Nullable
        public String getArch() {
            return this.arch;
        }

        @Nullable
        public String getCommand() {
            return this.command;
        }

        @Nullable
        public Map<String, String> getEnv() {
            return this.env;
        }
    }
}

