/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;

public class StateNamespaces {
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');

    public static StateNamespace global() {
        return new GlobalNamespace();
    }

    public static <W extends BoundedWindow> StateNamespace window(Coder<W> windowCoder, W window) {
        return new WindowNamespace(windowCoder, window, null);
    }

    public static <W extends BoundedWindow> StateNamespace windowAndTrigger(Coder<W> windowCoder, W window, int triggerIdx) {
        return new WindowAndTriggerNamespace(windowCoder, window, triggerIdx, null);
    }

    private StateNamespaces() {
    }

    public static <W extends BoundedWindow> StateNamespace fromString(String stringKey, Coder<W> windowCoder) {
        if (!stringKey.startsWith("/") || !stringKey.endsWith("/")) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'");
        }
        if ("/".equals(stringKey)) {
            return StateNamespaces.global();
        }
        List parts = SLASH_SPLITTER.splitToList((CharSequence)stringKey);
        if (parts.size() != 3 && parts.size() != 4) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'");
        }
        if (!((String)parts.get(0)).isEmpty() || !((String)parts.get(parts.size() - 1)).isEmpty()) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'");
        }
        try {
            BoundedWindow window = (BoundedWindow)CoderUtils.decodeFromBase64(windowCoder, (String)((String)parts.get(1)));
            if (parts.size() > 3) {
                int index = Integer.parseInt((String)parts.get(2), 36);
                return StateNamespaces.windowAndTrigger(windowCoder, window, index);
            }
            return StateNamespaces.window(windowCoder, window);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'", e);
        }
    }

    public static class WindowAndTriggerNamespace<W extends BoundedWindow>
    implements StateNamespace {
        private static final int TRIGGER_RADIX = 36;
        private Coder<W> windowCoder;
        private W window;
        private int triggerIndex;

        private WindowAndTriggerNamespace(Coder<W> windowCoder, W window, int triggerIndex) {
            this.windowCoder = windowCoder;
            this.window = window;
            this.triggerIndex = triggerIndex;
        }

        public W getWindow() {
            return this.window;
        }

        public int getTriggerIndex() {
            return this.triggerIndex;
        }

        @Override
        public String stringKey() {
            try {
                return "/" + CoderUtils.encodeToBase64(this.windowCoder, this.window) + "/" + Integer.toString(this.triggerIndex, 36).toUpperCase() + "/";
            }
            catch (CoderException e) {
                throw new RuntimeException("Unable to generate string key from window " + this.window, e);
            }
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append('/').append(CoderUtils.encodeToBase64(this.windowCoder, this.window));
            sb.append('/').append(Integer.toString(this.triggerIndex, 36).toUpperCase());
            sb.append('/');
        }

        @Override
        public Object getCacheKey() {
            return this.window;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WindowAndTriggerNamespace)) {
                return false;
            }
            WindowAndTriggerNamespace that = (WindowAndTriggerNamespace)obj;
            return this.triggerIndex == that.triggerIndex && Objects.equals(this.windowStructuralValue(), that.windowStructuralValue());
        }

        private Object windowStructuralValue() {
            return this.windowCoder.structuralValue(this.window);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Namespace.WINDOW_AND_TRIGGER, this.window, this.triggerIndex});
        }

        public String toString() {
            return "WindowAndTrigger(" + this.window + "," + this.triggerIndex + ")";
        }

        /* synthetic */ WindowAndTriggerNamespace(Coder x0, BoundedWindow x1, int x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class WindowNamespace<W extends BoundedWindow>
    implements StateNamespace {
        private Coder<W> windowCoder;
        private W window;

        private WindowNamespace(Coder<W> windowCoder, W window) {
            this.windowCoder = windowCoder;
            this.window = window;
        }

        public W getWindow() {
            return this.window;
        }

        @Override
        public String stringKey() {
            try {
                return "/" + CoderUtils.encodeToBase64(this.windowCoder, this.window) + "/";
            }
            catch (CoderException e) {
                throw new RuntimeException("Unable to generate string key from window " + this.window, e);
            }
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append('/').append(CoderUtils.encodeToBase64(this.windowCoder, this.window)).append('/');
        }

        @Override
        public Object getCacheKey() {
            return this.window;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WindowNamespace)) {
                return false;
            }
            WindowNamespace that = (WindowNamespace)obj;
            return Objects.equals(this.windowStructuralValue(), that.windowStructuralValue());
        }

        private Object windowStructuralValue() {
            return this.windowCoder.structuralValue(this.window);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Namespace.WINDOW, this.window});
        }

        public String toString() {
            return "Window(" + this.window + ")";
        }

        /* synthetic */ WindowNamespace(Coder x0, BoundedWindow x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class GlobalNamespace
    implements StateNamespace {
        private static final String GLOBAL_STRING = "/";

        @Override
        public String stringKey() {
            return GLOBAL_STRING;
        }

        @Override
        public Object getCacheKey() {
            return GLOBAL_STRING;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof GlobalNamespace;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Namespace.GLOBAL});
        }

        public String toString() {
            return "Global";
        }

        @Override
        public void appendTo(Appendable sb) throws IOException {
            sb.append(GLOBAL_STRING);
        }
    }

    private static enum Namespace {
        GLOBAL,
        WINDOW,
        WINDOW_AND_TRIGGER;

    }
}

