/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import org.apache.beam.repackaged.beam_runners_direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.direct.portable.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.portable.DirectTimerInternals;
import org.apache.beam.runners.direct.portable.StepStateAndTimers;

class DirectStateAndTimers<K>
implements StepStateAndTimers<K> {
    private final StructuralKey<K> key;
    private final CopyOnAccessInMemoryStateInternals existingState;
    private final Clock clock;
    private final WatermarkManager.TransformWatermarks watermarks;
    private CopyOnAccessInMemoryStateInternals<K> stateInternals;
    private DirectTimerInternals timerInternals;

    DirectStateAndTimers(StructuralKey<K> key, CopyOnAccessInMemoryStateInternals existingState, Clock clock, WatermarkManager.TransformWatermarks watermarks) {
        this.key = key;
        this.existingState = existingState;
        this.clock = clock;
        this.watermarks = watermarks;
    }

    @Override
    public CopyOnAccessInMemoryStateInternals<K> stateInternals() {
        if (this.stateInternals == null) {
            this.stateInternals = CopyOnAccessInMemoryStateInternals.withUnderlying(this.key, this.existingState);
        }
        return this.stateInternals;
    }

    @Override
    public DirectTimerInternals timerInternals() {
        if (this.timerInternals == null) {
            this.timerInternals = DirectTimerInternals.create(this.clock, this.watermarks, WatermarkManager.TimerUpdate.builder(this.key));
        }
        return this.timerInternals;
    }
}

