/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.WindowIntoTranslation;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.PassthroughTransformEvaluator;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.joda.time.Instant;

class WindowEvaluatorFactory
implements TransformEvaluatorFactory {
    private final EvaluationContext evaluationContext;

    WindowEvaluatorFactory(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, @Nullable CommittedBundle<?> inputBundle) throws Exception {
        return this.createTransformEvaluator(application);
    }

    private <InputT> TransformEvaluator<InputT> createTransformEvaluator(AppliedPTransform<PCollection<InputT>, PCollection<InputT>, Window.Assign<InputT>> transform) {
        WindowFn<?, ?> fn = WindowIntoTranslation.getWindowFn(transform);
        UncommittedBundle outputBundle = this.evaluationContext.createBundle((PCollection)Iterables.getOnlyElement(transform.getOutputs().values()));
        if (fn == null) {
            return PassthroughTransformEvaluator.create(transform, outputBundle);
        }
        return new WindowIntoEvaluator<InputT>(transform, fn, outputBundle);
    }

    @Override
    public void cleanup() {
    }

    private static class DirectAssignContext<InputT, W extends BoundedWindow>
    extends WindowFn.AssignContext {
        private final WindowedValue<InputT> value;

        public DirectAssignContext(WindowFn<InputT, W> fn, WindowedValue<InputT> value) {
            super(fn);
            this.value = value;
        }

        public InputT element() {
            return (InputT)this.value.getValue();
        }

        public Instant timestamp() {
            return this.value.getTimestamp();
        }

        public BoundedWindow window() {
            return (BoundedWindow)Iterables.getOnlyElement((Iterable)this.value.getWindows());
        }
    }

    private static class WindowIntoEvaluator<InputT>
    implements TransformEvaluator<InputT> {
        private final AppliedPTransform<PCollection<InputT>, PCollection<InputT>, Window.Assign<InputT>> transform;
        private final WindowFn<InputT, ?> windowFn;
        private final UncommittedBundle<InputT> outputBundle;

        public WindowIntoEvaluator(AppliedPTransform<PCollection<InputT>, PCollection<InputT>, Window.Assign<InputT>> transform, WindowFn<? super InputT, ?> windowFn, UncommittedBundle<InputT> outputBundle) {
            this.outputBundle = outputBundle;
            this.transform = transform;
            this.windowFn = windowFn;
        }

        @Override
        public void processElement(WindowedValue<InputT> compressedElement) throws Exception {
            for (WindowedValue element : compressedElement.explodeWindows()) {
                Collection<BoundedWindow> windows = this.assignWindows(this.windowFn, element);
                this.outputBundle.add(WindowedValue.of((Object)element.getValue(), (Instant)element.getTimestamp(), windows, (PaneInfo)element.getPane()));
            }
        }

        private <W extends BoundedWindow> Collection<? extends BoundedWindow> assignWindows(WindowFn<InputT, W> windowFn, WindowedValue<InputT> element) throws Exception {
            DirectAssignContext<InputT, W> assignContext = new DirectAssignContext<InputT, W>(windowFn, element);
            return windowFn.assignWindows(assignContext);
        }

        @Override
        public TransformResult<InputT> finishBundle() throws Exception {
            return StepTransformResult.withoutHold(this.transform).addOutput(this.outputBundle, new UncommittedBundle[0]).build();
        }
    }
}

