/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.stream;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

@ThreadSafe
public final class BufferingStreamObserver<T>
implements StreamObserver<T> {
    private static final Object POISON_PILL = new Object();
    private final LinkedBlockingDeque<T> queue;
    private final Phaser phaser;
    private final CallStreamObserver<T> outboundObserver;
    private final Future<?> queueDrainer;
    private final int bufferSize;

    public BufferingStreamObserver(Phaser phaser, CallStreamObserver<T> outboundObserver, ExecutorService executor, int bufferSize) {
        this.phaser = phaser;
        this.bufferSize = bufferSize;
        this.queue = new LinkedBlockingDeque(bufferSize);
        this.outboundObserver = outboundObserver;
        this.queueDrainer = executor.submit(this::drainQueue);
    }

    private void drainQueue() {
        try {
            while (true) {
                int currentPhase = this.phaser.getPhase();
                while (this.outboundObserver.isReady()) {
                    T value = this.queue.take();
                    if (value != POISON_PILL) {
                        this.outboundObserver.onNext(value);
                        continue;
                    }
                    return;
                }
                this.phaser.awaitAdvance(currentPhase);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public void onNext(T value) {
        try {
            while (!this.queue.offer(value, 60L, TimeUnit.SECONDS)) {
                Preconditions.checkState((!this.queueDrainer.isDone() ? 1 : 0) != 0, (Object)"Stream observer has finished.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        CallStreamObserver<T> callStreamObserver = this.outboundObserver;
        synchronized (callStreamObserver) {
            if (!this.queueDrainer.isDone()) {
                try {
                    while (!this.queueDrainer.isDone() && !this.queue.offerFirst(POISON_PILL, 60L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                this.waitTillFinish();
            }
            this.outboundObserver.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        CallStreamObserver<T> callStreamObserver = this.outboundObserver;
        synchronized (callStreamObserver) {
            if (!this.queueDrainer.isDone()) {
                try {
                    while (!this.queueDrainer.isDone() && !this.queue.offerLast(POISON_PILL, 60L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                this.waitTillFinish();
            }
            this.outboundObserver.onCompleted();
        }
    }

    @VisibleForTesting
    public int getBufferSize() {
        return this.bufferSize;
    }

    private void waitTillFinish() {
        try {
            this.queueDrainer.get();
        }
        catch (CancellationException e) {
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

