/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data;

import com.google.auto.value.AutoValue;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.AutoValue_RemoteGrpcPortWrite;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

@AutoValue
public abstract class RemoteGrpcPortWrite {
    public static final String URN = "urn:org.apache.beam:sink:runner:0.1";
    private static final String LOCAL_INPUT_ID = "local_input";

    public static RemoteGrpcPortWrite writeToPort(String inputPCollectionId, BeamFnApi.RemoteGrpcPort port) {
        return new AutoValue_RemoteGrpcPortWrite(inputPCollectionId, port);
    }

    public static RemoteGrpcPortWrite fromPTransform(RunnerApi.PTransform pTransform) throws InvalidProtocolBufferException {
        Preconditions.checkArgument((boolean)URN.equals(pTransform.getSpec().getUrn()), (String)"Expected URN for %s, got %s", (Object)RemoteGrpcPortWrite.class.getSimpleName(), (Object)pTransform.getSpec().getUrn());
        Preconditions.checkArgument((pTransform.getInputsCount() == 1 ? 1 : 0) != 0, (String)"Expected exactly one output, got %s", (int)pTransform.getOutputsCount());
        BeamFnApi.RemoteGrpcPort port = BeamFnApi.RemoteGrpcPort.parseFrom((ByteString)pTransform.getSpec().getPayload());
        String inputPCollectionId = (String)Iterables.getOnlyElement(pTransform.getInputsMap().values());
        return RemoteGrpcPortWrite.writeToPort(inputPCollectionId, port);
    }

    abstract String getInputPCollectionId();

    public abstract BeamFnApi.RemoteGrpcPort getPort();

    public RunnerApi.PTransform toPTransform() {
        return RunnerApi.PTransform.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(URN).setPayload(this.getPort().toByteString()).build()).putInputs(LOCAL_INPUT_ID, this.getInputPCollectionId()).build();
    }
}

