/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.translation;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Sets;

public final class PipelineTranslatorUtils {
    private PipelineTranslatorUtils() {
    }

    public static BiMap<String, Integer> createOutputMap(Iterable<String> localOutputs) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        int outputIndex = 0;
        for (String tag : Sets.newTreeSet(localOutputs)) {
            builder.put((Object)tag, (Object)outputIndex);
            ++outputIndex;
        }
        return builder.build();
    }

    public static <T> Coder<WindowedValue<T>> instantiateCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection(collectionId, components.getPcollectionsOrThrow(collectionId));
        try {
            return WireCoders.instantiateRunnerWireCoder(collectionNode, components);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate Coder", e);
        }
    }

    public static WindowingStrategy getWindowingStrategy(String pCollectionId, RunnerApi.Components components) {
        RunnerApi.WindowingStrategy windowingStrategyProto = components.getWindowingStrategiesOrThrow(components.getPcollectionsOrThrow(pCollectionId).getWindowingStrategyId());
        try {
            return WindowingStrategyTranslation.fromProto(windowingStrategyProto, RehydratedComponents.forComponents(components));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Unable to hydrate windowing strategy %s for %s.", windowingStrategyProto, pCollectionId), e);
        }
    }
}

