/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;

public class MonitoringInfoMetricName
extends MetricName {
    private String urn;
    @Nullable
    private String name;
    @Nullable
    private String namespace;
    private HashMap<String, String> labels = new HashMap();

    private MonitoringInfoMetricName(String urn, HashMap<String, String> labels) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)urn) ? 1 : 0) != 0, (Object)"MonitoringInfoMetricName urn must be non-empty");
        Preconditions.checkArgument((labels != null ? 1 : 0) != 0, (Object)"MonitoringInfoMetricName labels must be non-null");
        this.urn = urn;
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            this.labels.put(entry.getKey(), entry.getValue());
        }
    }

    private void parseUrn() {
        if (this.urn.startsWith(SimpleMonitoringInfoBuilder.USER_COUNTER_URN_PREFIX)) {
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(this.getUrn().split(":")));
            this.name = (String)split.get(split.size() - 1);
            this.namespace = (String)split.get(split.size() - 2);
        }
    }

    public String getNamespace() {
        if (this.namespace == null) {
            this.parseUrn();
        }
        return this.namespace;
    }

    public String getName() {
        if (this.name == null) {
            this.parseUrn();
        }
        return this.name;
    }

    public String getUrn() {
        return this.urn;
    }

    public HashMap<String, String> getLabels() {
        return this.labels;
    }

    public static MonitoringInfoMetricName named(String urn, HashMap<String, String> labels) {
        return new MonitoringInfoMetricName(urn, labels);
    }

    public int hashCode() {
        return Objects.hash(this.urn, this.labels);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoringInfoMetricName)) {
            return false;
        }
        MonitoringInfoMetricName other = (MonitoringInfoMetricName)((Object)o);
        return this.urn.equals(other.urn) && this.labels.equals(other.labels);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.urn.toString());
        builder.append(" ");
        builder.append(this.labels.toString());
        return builder.toString();
    }
}

