/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;

@Experimental(value=Experimental.Kind.METRICS)
@Internal
public class DirtyState
implements Serializable {
    private final AtomicReference<State> dirty = new AtomicReference<State>(State.DIRTY);

    public void afterModification() {
        this.dirty.set(State.DIRTY);
    }

    public boolean beforeCommit() {
        State state;
        while ((state = this.dirty.get()) != State.CLEAN && !this.dirty.compareAndSet(state, State.COMMITTING)) {
        }
        return state != State.CLEAN;
    }

    public void afterCommit() {
        this.dirty.compareAndSet(State.COMMITTING, State.CLEAN);
    }

    public boolean equals(Object object) {
        if (object instanceof DirtyState) {
            DirtyState dirtyState = (DirtyState)object;
            return Objects.equals((Object)this.dirty.get(), (Object)dirtyState.dirty.get());
        }
        return false;
    }

    public int hashCode() {
        return this.dirty.get().hashCode();
    }

    private static enum State {
        DIRTY,
        CLEAN,
        COMMITTING;

    }
}

