/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.netty.v4.io.netty.handler.ipfilter;

import java.net.InetSocketAddress;
import org.apache.beam.vendor.netty.v4.io.netty.channel.ChannelHandler;
import org.apache.beam.vendor.netty.v4.io.netty.channel.ChannelHandlerContext;
import org.apache.beam.vendor.netty.v4.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import org.apache.beam.vendor.netty.v4.io.netty.handler.ipfilter.IpFilterRule;
import org.apache.beam.vendor.netty.v4.io.netty.handler.ipfilter.IpFilterRuleType;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        if (rules == null) {
            throw new NullPointerException("rules");
        }
        this.rules = rules;
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

