/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1.io.grpc.netty;

import org.apache.beam.vendor.grpc.v1.io.grpc.internal.WritableBuffer;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.WritableBufferAllocator;
import org.apache.beam.vendor.grpc.v1.io.grpc.netty.NettyWritableBuffer;
import org.apache.beam.vendor.netty.v4.io.netty.buffer.ByteBufAllocator;

class NettyWritableBufferAllocator
implements WritableBufferAllocator {
    private static final int MIN_BUFFER = 4096;
    private static final int MAX_BUFFER = 0x100000;
    private final ByteBufAllocator allocator;

    NettyWritableBufferAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public WritableBuffer allocate(int capacityHint) {
        capacityHint = Math.min(0x100000, Math.max(4096, capacityHint));
        return new NettyWritableBuffer(this.allocator.buffer(capacityHint, capacityHint));
    }
}

