/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1.io.grpc.internal;

import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.vendor.grpc.v1.io.grpc.CallCredentials;
import org.apache.beam.vendor.grpc.v1.io.grpc.CallOptions;
import org.apache.beam.vendor.grpc.v1.io.grpc.Context;
import org.apache.beam.vendor.grpc.v1.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1.io.grpc.MethodDescriptor;
import org.apache.beam.vendor.grpc.v1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.ClientStream;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.ClientTransport;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.DelayedStream;
import org.apache.beam.vendor.grpc.v1.io.grpc.internal.FailingClientStream;
import org.apache.beam.vendor.guava.v20.com.google.common.base.Preconditions;

final class MetadataApplierImpl
implements CallCredentials.MetadataApplier {
    private final ClientTransport transport;
    private final MethodDescriptor<?, ?> method;
    private final Metadata origHeaders;
    private final CallOptions callOptions;
    private final Context ctx;
    private final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    private ClientStream returnedStream;
    boolean finalized;
    DelayedStream delayedStream;

    MetadataApplierImpl(ClientTransport transport, MethodDescriptor<?, ?> method, Metadata origHeaders, CallOptions callOptions) {
        this.transport = transport;
        this.method = method;
        this.origHeaders = origHeaders;
        this.callOptions = callOptions;
        this.ctx = Context.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Metadata headers) {
        ClientStream realStream;
        Preconditions.checkState(!this.finalized, "apply() or fail() already called");
        Preconditions.checkNotNull(headers, "headers");
        this.origHeaders.merge(headers);
        Context origCtx = this.ctx.attach();
        try {
            realStream = this.transport.newStream(this.method, this.origHeaders, this.callOptions);
        }
        finally {
            this.ctx.detach(origCtx);
        }
        this.finalizeWith(realStream);
    }

    @Override
    public void fail(Status status) {
        Preconditions.checkArgument(!status.isOk(), "Cannot fail with OK status");
        Preconditions.checkState(!this.finalized, "apply() or fail() already called");
        this.finalizeWith(new FailingClientStream(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeWith(ClientStream stream) {
        Preconditions.checkState(!this.finalized, "already finalized");
        this.finalized = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.returnedStream = stream;
                return;
            }
        }
        Preconditions.checkState(this.delayedStream != null, "delayedStream is null");
        this.delayedStream.setStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientStream returnStream() {
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.delayedStream = new DelayedStream();
                this.returnedStream = this.delayedStream;
                return this.returnedStream;
            }
            return this.returnedStream;
        }
    }
}

