/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.servlet;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import org.apache.batchee.servlet.JBatchController;
import org.apache.batchee.servlet.JBatchServletInitializer;
import org.apache.batchee.servlet.util.CreateSomeJobs;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ServletTest {
    @ArquillianResource
    private URL base;

    @Deployment(testable=false)
    public static Archive<?> war() {
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"batchee-gui.war")).addAsWebInfResource((Asset)new StringAsset(((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).metadataComplete(Boolean.valueOf(true)).createListener().listenerClass(CreateSomeJobs.class.getName()).up()).createFilter().filterName("JBatch Private Filter").filterClass(JBatchServletInitializer.PrivateFilter.class.getName()).up()).createServlet().servletName("JBatch").servletClass(JBatchController.class.getName()).loadOnStartup(Integer.valueOf(1)).up()).createFilterMapping().filterName("JBatch Private Filter").urlPattern(new String[]{"/*"}).up()).createServletMapping().servletName("JBatch").urlPattern(new String[]{"/jbatch/*"}).up()).exportAsString()), "web.xml")).addPackages(true, new Package[]{JBatchController.class.getPackage()})).addPackage(CreateSomeJobs.class.getPackage())).addAsWebInfResource("META-INF/batch-jobs/init.xml", "classes/META-INF/batch-jobs/init.xml");
        for (String resource : Arrays.asList("layout.jsp", "jobs.jsp", "job-instances.jsp", "step-executions.jsp", "css/bootstrap.min.3.0.0.css", "js/bootstrap.min.3.0.0.js")) {
            webArchive.addAsWebResource("META-INF/resources/internal/batchee/" + resource, "internal/batchee/" + resource);
        }
        return webArchive;
    }

    @Test
    public void home() throws IOException {
        Assert.assertEquals((Object)"init", (Object)this.extractContent("", "/ul/li/a[1]/text()"));
    }

    @Test
    public void instances() throws IOException {
        Assert.assertEquals((Object)BatchStatus.COMPLETED.name(), (Object)this.extractContent("executions/init", "/table/tbody/tr/td[2]"));
    }

    @Test
    public void steps() throws IOException {
        Assert.assertEquals((Object)"step1", (Object)this.extractContent("step-executions/0", "/table/tbody/tr/td[2]"));
    }

    @Test(expected=FailingHttpStatusCodeException.class)
    public void privateUrl() throws IOException {
        WebClient client = this.newWebClient();
        client.getPage(this.base.toExternalForm() + "jbatch/internal/batchee/jobs.jsp");
    }

    @Test
    public void testSimpleRest() throws IOException, InterruptedException {
        String textContent = this.executeSimpleRest("start/init?value=OK&sleep=2");
        Long executionId = this.extractExecutionId(textContent);
        Thread.sleep(100L);
        textContent = this.executeSimpleRest("status/" + executionId);
        String[] parms = textContent.split("\n");
        Assert.assertTrue((parms.length == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)BatchStatus.STARTED.toString(), (Object)parms[2]);
        boolean stopped = false;
        for (int i = 0; i < 11; ++i) {
            textContent = this.executeSimpleRest("status/" + executionId);
            parms = textContent.split("\n");
            Assert.assertTrue((parms.length == 3 ? 1 : 0) != 0);
            if (BatchStatus.COMPLETED.toString().equals(parms[2])) {
                stopped = true;
                break;
            }
            Thread.sleep(200L);
        }
        if (!stopped) {
            Assert.fail((String)("failed to properly stop the batch. Last status = " + parms[2]));
        }
    }

    private String executeSimpleRest(String command) throws IOException {
        String startUrl = this.base.toExternalForm() + "jbatch/rest/" + command;
        WebClient webClient = this.newWebClient();
        TextPage page = (TextPage)webClient.getPage(startUrl);
        String textContent = page.getContent();
        Assert.assertNotNull((Object)textContent);
        Assert.assertTrue((boolean)textContent.contains("\nOK\n"));
        this.extractExecutionId(textContent);
        return textContent;
    }

    private Long extractExecutionId(String textContent) {
        String[] parms = textContent.split("\n");
        Assert.assertTrue((parms.length >= 2 ? 1 : 0) != 0);
        Long executionId = Long.valueOf(parms[0]);
        Assert.assertTrue((-1L != executionId ? 1 : 0) != 0);
        return executionId;
    }

    private String extractContent(String endUrl, String xpath) throws IOException {
        String url = this.base.toExternalForm() + "jbatch/" + endUrl;
        WebClient webClient = this.newWebClient();
        HtmlPage page = (HtmlPage)webClient.getPage(url);
        List byXPath = page.getByXPath("//div[@id=\"content\"]" + xpath);
        Assert.assertTrue((byXPath.size() >= 1 ? 1 : 0) != 0);
        Object next = byXPath.iterator().next();
        if (!DomNode.class.isInstance(next)) {
            throw new IllegalArgumentException("Can't find text for " + next);
        }
        return ((DomNode)DomNode.class.cast(next)).asText();
    }

    private WebClient newWebClient() {
        WebClient webClient = new WebClient();
        webClient.getOptions().setJavaScriptEnabled(false);
        webClient.getOptions().setCssEnabled(false);
        webClient.getOptions().setAppletEnabled(false);
        return webClient;
    }
}

