/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.pubsub;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.Subscription;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.pubsub.ConnectionUtils$;
import org.apache.spark.streaming.pubsub.SparkGCPCredentials;
import org.apache.spark.streaming.pubsub.SparkPubsubMessage;
import org.apache.spark.streaming.receiver.Receiver;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!B\u0001\u0003\u0001\ta!A\u0004)vEN,(MU3dK&4XM\u001d\u0006\u0003\u0007\u0011\ta\u0001];cgV\u0014'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002E\u0002\u000f#Mi\u0011a\u0004\u0006\u0003!\u0011\t\u0001B]3dK&4XM]\u0005\u0003%=\u0011\u0001BU3dK&4XM\u001d\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011!c\u00159be.\u0004VOY:vE6+7o]1hK\"A\u0001\u0004\u0001B\u0001B\u0003%!$A\u0004qe>TWm\u0019;\u0004\u0001A\u00111\u0004\n\b\u00039\t\u0002\"!\b\u0011\u000e\u0003yQ!aH\r\u0002\rq\u0012xn\u001c;?\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0003\u0019\u0001&/\u001a3fM&\u0011QE\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\u0002\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u000bQ|\u0007/[2\u0011\u0007)Z#$D\u0001!\u0013\ta\u0003E\u0001\u0004PaRLwN\u001c\u0005\t]\u0001\u0011\t\u0011)A\u00055\u0005a1/\u001e2tGJL\u0007\u000f^5p]\"A\u0001\u0007\u0001B\u0001B\u0003%\u0011'\u0001\u0006de\u0016$WM\u001c;jC2\u0004\"\u0001\u0006\u001a\n\u0005M\u0012!aE*qCJ\\wi\u0011)De\u0016$WM\u001c;jC2\u001c\b\"C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c=\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\t9$(D\u00019\u0015\tId!A\u0004ti>\u0014\u0018mZ3\n\u0005mB$\u0001D*u_J\fw-\u001a'fm\u0016d\u0017BA\u001b\u0012\u0011!q\u0004A!A!\u0002\u0013y\u0014aD1vi>\f5m\u001b8po2,GmZ3\u0011\u0005)\u0002\u0015BA!!\u0005\u001d\u0011un\u001c7fC:DQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0001P5oSRtDcB#G\u000f\"K%j\u0013\t\u0003)\u0001AQ\u0001\u0007\"A\u0002iAQ\u0001\u000b\"A\u0002%BQA\f\"A\u0002iAQ\u0001\r\"A\u0002EBQ!\u000e\"A\u0002YBQA\u0010\"A\u0002}Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0005B!B{f*Q'F+\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0011a\u0017M\\4\u000b\u0003Q\u000bAA[1wC&\u0011Q%\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B(\u0002\u0013\u0005\u0003\u0006k\u0018(B\u001b\u0016\u0003\u0003bB-\u0001\u0005\u0004%\tAW\u0001\r\u0013:KEk\u0018\"B\u0007.{eIR\u000b\u00027B\u0011!\u0006X\u0005\u0003;\u0002\u00121!\u00138u\u0011\u0019y\u0006\u0001)A\u00057\u0006i\u0011JT%U?\n\u000b5iS(G\r\u0002Bq!\u0019\u0001C\u0002\u0013\u0005!,A\u0006N\u0003b{&)Q\"L\u001f\u001a3\u0005BB2\u0001A\u0003%1,\u0001\u0007N\u0003b{&)Q\"L\u001f\u001a3\u0005\u0005C\u0004f\u0001\t\u0007I\u0011\u0001.\u0002\u00175\u000b\u0005lX'F'N\u000bu)\u0012\u0005\u0007O\u0002\u0001\u000b\u0011B.\u0002\u00195\u000b\u0005lX'F'N\u000bu)\u0012\u0011\t\u0011%\u0004\u0001R1A\u0005\u0002)\faa\u00197jK:$X#A6\u0011\u000514X\"A7\u000b\u0005\rq'BA8q\u0003!\u0019XM\u001d<jG\u0016\u001c(BA9s\u0003\r\t\u0007/\u001b\u0006\u0003gR\faaZ8pO2,'\"A;\u0002\u0007\r|W.\u0003\u0002x[\n1\u0001+\u001e2tk\nDq!\u001f\u0001C\u0002\u0013\u0005!0A\bqe>TWm\u0019;Gk2dg*Y7f+\u0005Q\u0002B\u0002?\u0001A\u0003%!$\u0001\tqe>TWm\u0019;Gk2dg*Y7fA!9a\u0010\u0001b\u0001\n\u0003Q\u0018\u0001F:vEN\u001c'/\u001b9uS>tg)\u001e7m\u001d\u0006lW\rC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002\u000e\u0002+M,(m]2sSB$\u0018n\u001c8Gk2dg*Y7fA!9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011aB8o'R\f'\u000f\u001e\u000b\u0003\u0003\u0013\u00012AKA\u0006\u0013\r\ti\u0001\t\u0002\u0005+:LG\u000fC\u0004\u0002\u0012\u0001!\t!a\u0002\u0002\u000fI,7-Z5wK\"9\u0011Q\u0003\u0001\u0005B\u0005\u001d\u0011AB8o'R|\u0007\u000f")
public class PubsubReceiver
extends Receiver<SparkPubsubMessage> {
    private Pubsub client;
    private final Option<String> topic;
    private final SparkGCPCredentials credential;
    private final boolean autoAcknowledge;
    private final String APP_NAME;
    private final int INIT_BACKOFF;
    private final int MAX_BACKOFF;
    private final int MAX_MESSAGE;
    private final String projectFullName;
    private final String subscriptionFullName;
    private volatile boolean bitmap$0;

    public String APP_NAME() {
        return this.APP_NAME;
    }

    public int INIT_BACKOFF() {
        return this.INIT_BACKOFF;
    }

    public int MAX_BACKOFF() {
        return this.MAX_BACKOFF;
    }

    public int MAX_MESSAGE() {
        return this.MAX_MESSAGE;
    }

    private Pubsub client$lzycompute() {
        PubsubReceiver pubsubReceiver = this;
        synchronized (pubsubReceiver) {
            if (!this.bitmap$0) {
                this.client = new Pubsub.Builder((HttpTransport)ConnectionUtils$.MODULE$.transport(), (JsonFactory)ConnectionUtils$.MODULE$.jacksonFactory(), (HttpRequestInitializer)new RetryHttpInitializer(this.credential.provider(), this.APP_NAME())).setApplicationName(this.APP_NAME()).build();
                this.bitmap$0 = true;
            }
        }
        this.credential = null;
        return this.client;
    }

    public Pubsub client() {
        return !this.bitmap$0 ? this.client$lzycompute() : this.client;
    }

    public String projectFullName() {
        return this.projectFullName;
    }

    public String subscriptionFullName() {
        return this.subscriptionFullName;
    }

    public void onStart() {
        Object object;
        Option<String> option = this.topic;
        if (option instanceof Some) {
            Object object2;
            Some some = (Some)option;
            String t = (String)some.value();
            Subscription sub = new Subscription();
            sub.setTopic(new StringBuilder(8).append(this.projectFullName()).append("/topics/").append(t).toString());
            try {
                object2 = this.client().projects().subscriptions().create(this.subscriptionFullName(), sub).execute();
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof GoogleJsonResponseException) {
                    BoxedUnit boxedUnit2;
                    GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)throwable2;
                    if (googleJsonResponseException.getDetails().getCode() == ConnectionUtils$.MODULE$.ALREADY_EXISTS()) {
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.reportError("Failed to create subscription", (Throwable)googleJsonResponseException);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                } else {
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option2.isEmpty()) {
                        Throwable e = (Throwable)option2.get();
                        this.reportError("Failed to create subscription", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw throwable;
                    }
                }
                object2 = boxedUnit;
            }
            object = object2;
        } else if (None$.MODULE$.equals(option)) {
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        new Thread(this){
            private final /* synthetic */ PubsubReceiver $outer;

            public void run() {
                this.$outer.receive();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
    }

    public void receive() {
        PullRequest pullRequest = new PullRequest().setMaxMessages(Predef$.MODULE$.int2Integer(this.MAX_MESSAGE())).setReturnImmediately(Predef$.MODULE$.boolean2Boolean(false));
        int backoff = this.INIT_BACKOFF();
        while (!this.isStopped()) {
            try {
                Object object;
                PullResponse pullResponse = (PullResponse)this.client().projects().subscriptions().pull(this.subscriptionFullName(), pullRequest).execute();
                List receivedMessages = pullResponse.getReceivedMessages();
                if (receivedMessages != null) {
                    this.store(((LinearSeqLike)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(receivedMessages).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x -> {
                        void var1_1;
                        SparkPubsubMessage sm = new SparkPubsubMessage();
                        sm.message_$eq(x.getMessage());
                        sm.ackId_$eq(x.getAckId());
                        return var1_1;
                    }, List$.MODULE$.canBuildFrom())).iterator());
                    if (this.autoAcknowledge) {
                        AcknowledgeRequest ackRequest = new AcknowledgeRequest();
                        ackRequest.setAckIds((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(receivedMessages).asScala()).map((Function1 & Serializable & scala.Serializable)x -> x.getAckId(), Buffer$.MODULE$.canBuildFrom())).asJava());
                        object = this.client().projects().subscriptions().acknowledge(this.subscriptionFullName(), ackRequest).execute();
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                backoff = this.INIT_BACKOFF();
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof GoogleJsonResponseException) {
                    BoxedUnit boxedUnit2;
                    GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)throwable2;
                    if (ConnectionUtils$.MODULE$.retryable(googleJsonResponseException.getDetails().getCode())) {
                        Thread.sleep(backoff);
                        backoff = Math.min(backoff * 2, this.MAX_BACKOFF());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.reportError("Failed to pull messages", (Throwable)googleJsonResponseException);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.reportError("Failed to pull messages", e);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
    }

    public void onStop() {
    }

    public PubsubReceiver(String project, Option<String> topic, String subscription, SparkGCPCredentials credential, StorageLevel storageLevel, boolean autoAcknowledge) {
        this.topic = topic;
        this.credential = credential;
        this.autoAcknowledge = autoAcknowledge;
        super(storageLevel);
        this.APP_NAME = "sparkstreaming-pubsub-receiver";
        this.INIT_BACKOFF = 100;
        this.MAX_BACKOFF = 10000;
        this.MAX_MESSAGE = 1000;
        this.projectFullName = new StringBuilder(9).append("projects/").append(project).toString();
        this.subscriptionFullName = new StringBuilder(15).append(this.projectFullName()).append("/subscriptions/").append(subscription).toString();
    }
}

