/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.ws.java2wsdl.DefaultNamespaceGenerator;
import org.apache.ws.java2wsdl.Java2OMBuilder;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.Java2WSDLUtils;
import org.apache.ws.java2wsdl.NamespaceGenerator;
import org.apache.ws.java2wsdl.SchemaGenerator;

public class Java2WSDLBuilder
implements Java2WSDLConstants {
    public static final String ALL = "all";
    private OutputStream out;
    private String className;
    private ClassLoader classLoader;
    private String wsdlPrefix = "wsdl";
    private String serviceName = null;
    private String targetNamespace = null;
    private String targetNamespacePrefix = null;
    private String attrFormDefault = null;
    private String elementFormDefault = null;
    private String schemaTargetNamespace = null;
    private String schemaTargetNamespacePrefix = null;
    private String style = "document";
    private String use = "literal";
    private String locationUri = "http://localhost:8080/axis2/services/";
    private ArrayList extraClasses;
    private String nsGenClassName = null;
    private Map pkg2nsMap = null;

    public String getSchemaTargetNamespace() throws Exception {
        if (this.schemaTargetNamespace == null) {
            this.schemaTargetNamespace = Java2WSDLUtils.schemaNamespaceFromClassName(this.className, this.classLoader, this.resolveNSGen()).toString();
        }
        return this.schemaTargetNamespace;
    }

    public String getStyle() {
        return this.style;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.schemaTargetNamespace = schemaTargetNamespace;
    }

    public String getSchemaTargetNamespacePrefix() {
        if (this.schemaTargetNamespacePrefix == null) {
            this.schemaTargetNamespacePrefix = "ns";
        }
        return this.schemaTargetNamespacePrefix;
    }

    public void setSchemaTargetNamespacePrefix(String schemaTargetNamespacePrefix) {
        this.schemaTargetNamespacePrefix = schemaTargetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespacePrefix() {
        return this.targetNamespacePrefix;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getWsdlPrefix() {
        return this.wsdlPrefix;
    }

    public void setWsdlPrefix(String wsdlPrefix) {
        this.wsdlPrefix = wsdlPrefix;
    }

    public Java2WSDLBuilder(OutputStream out, String className, ClassLoader classLoader) {
        this.out = out;
        this.className = className;
        this.classLoader = classLoader;
    }

    public void generateWSDL() throws Exception {
        SchemaGenerator schemaGenerator = new SchemaGenerator(this.classLoader, this.className, this.getSchemaTargetNamespace(), this.getSchemaTargetNamespacePrefix());
        ArrayList<String> excludedOperation = new ArrayList<String>();
        excludedOperation.add("init");
        excludedOperation.add("setOperationContext");
        excludedOperation.add("destroy");
        schemaGenerator.setExcludeMethods(excludedOperation);
        schemaGenerator.setAttrFormDefault(this.getAttrFormDefault());
        schemaGenerator.setElementFormDefault(this.getElementFormDefault());
        schemaGenerator.setExtraClasses(this.getExtraClasses());
        schemaGenerator.setNsGen(this.resolveNSGen());
        schemaGenerator.setPkg2nsmap(this.getPkg2nsMap());
        if (this.getPkg2nsMap() != null && !this.getPkg2nsMap().isEmpty() && (this.getPkg2nsMap().containsKey(ALL) || this.getPkg2nsMap().containsKey(ALL.toUpperCase()))) {
            schemaGenerator.setUseWSDLTypesNamespace(true);
        }
        Collection schemaCollection = schemaGenerator.generateSchema();
        Java2OMBuilder java2OMBuilder = new Java2OMBuilder(schemaGenerator.getMethods(), schemaCollection, schemaGenerator.getTypeTable(), this.serviceName == null ? Java2WSDLUtils.getSimpleClassName(this.className) : this.serviceName, this.targetNamespace == null ? Java2WSDLUtils.namespaceFromClassName(this.className, this.classLoader, this.resolveNSGen()).toString() : this.targetNamespace, this.targetNamespacePrefix, this.style, this.use, this.locationUri);
        java2OMBuilder.setSchemaTargetNamespace(this.getSchemaTargetNamespace());
        java2OMBuilder.setSchemaTargetNamespacePrefix(this.getSchemaTargetNamespacePrefix());
        OMElement wsdlElement = java2OMBuilder.generateOM();
        wsdlElement.serialize(this.out);
        this.out.flush();
        this.out.close();
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public ArrayList getExtraClasses() {
        return this.extraClasses;
    }

    public void setExtraClasses(ArrayList extraClasses) {
        this.extraClasses = extraClasses;
    }

    public String getNsGenClassName() {
        return this.nsGenClassName;
    }

    public void setNsGenClassName(String nsGenClassName) {
        this.nsGenClassName = nsGenClassName;
    }

    public Map getPkg2nsMap() {
        return this.pkg2nsMap;
    }

    public void setPkg2nsMap(Map pkg2nsMap) {
        this.pkg2nsMap = pkg2nsMap;
    }

    private NamespaceGenerator resolveNSGen() {
        NamespaceGenerator nsGen = null;
        try {
            nsGen = (NamespaceGenerator)Class.forName(this.nsGenClassName).newInstance();
        }
        catch (Exception e) {
            nsGen = new DefaultNamespaceGenerator();
        }
        return nsGen;
    }
}

