/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.CsiAdaptorProtos;

public class ValidateVolumeCapabilitiesRequestPBImpl
extends ValidateVolumeCapabilitiesRequest {
    private CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest.Builder builder;

    public ValidateVolumeCapabilitiesRequestPBImpl(CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest proto) {
        this.builder = proto.toBuilder();
    }

    public ValidateVolumeCapabilitiesRequestPBImpl() {
        this.builder = CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest.newBuilder();
    }

    @Override
    public String getVolumeId() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.getVolumeId();
    }

    @Override
    public void setVolumeAttributes(Map<String, String> attributes) {
        Preconditions.checkNotNull(this.builder);
        this.builder.addAllVolumeAttributes(ProtoUtils.convertToProtoFormat(attributes));
    }

    @Override
    public void setVolumeId(String volumeId) {
        Preconditions.checkNotNull(this.builder);
        this.builder.setVolumeId(volumeId);
    }

    @Override
    public void addVolumeCapability(ValidateVolumeCapabilitiesRequest.VolumeCapability volumeCapability) {
        Preconditions.checkNotNull(this.builder);
        CsiAdaptorProtos.VolumeCapability vc = CsiAdaptorProtos.VolumeCapability.newBuilder().setAccessMode(CsiAdaptorProtos.VolumeCapability.AccessMode.forNumber(volumeCapability.getAccessMode().ordinal())).setVolumeType(CsiAdaptorProtos.VolumeCapability.VolumeType.forNumber(volumeCapability.getVolumeType().ordinal())).addAllMountFlags(volumeCapability.getMountFlags()).build();
        this.builder.addVolumeCapabilities(vc);
    }

    @Override
    public List<ValidateVolumeCapabilitiesRequest.VolumeCapability> getVolumeCapabilities() {
        Preconditions.checkNotNull(this.builder);
        ArrayList<ValidateVolumeCapabilitiesRequest.VolumeCapability> caps = new ArrayList<ValidateVolumeCapabilitiesRequest.VolumeCapability>(this.builder.getVolumeCapabilitiesCount());
        this.builder.getVolumeCapabilitiesList().forEach(capability -> {
            ValidateVolumeCapabilitiesRequest.VolumeCapability vc = new ValidateVolumeCapabilitiesRequest.VolumeCapability(ValidateVolumeCapabilitiesRequest.AccessMode.valueOf(capability.getAccessMode().name()), ValidateVolumeCapabilitiesRequest.VolumeType.valueOf(capability.getVolumeType().name()), capability.getMountFlagsList());
            caps.add(vc);
        });
        return caps;
    }

    @Override
    public Map<String, String> getVolumeAttributes() {
        Preconditions.checkNotNull(this.builder);
        return ProtoUtils.convertStringStringMapProtoListToMap(this.builder.getVolumeAttributesList());
    }

    public CsiAdaptorProtos.ValidateVolumeCapabilitiesRequest getProto() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.build();
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ValidateVolumeCapabilitiesRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }
}

