/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.mapred.AvroRecordReader;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AvroInputFormat<T>
extends FileInputFormat<AvroWrapper<T>, NullWritable> {
    public static final String IGNORE_FILES_WITHOUT_EXTENSION_KEY = "avro.mapred.ignore.inputs.without.extension";
    public static final boolean IGNORE_INPUTS_WITHOUT_EXTENSION_DEFAULT = true;

    @Override
    protected FileStatus[] listStatus(JobConf job) throws IOException {
        FileStatus[] status = super.listStatus(job);
        if (job.getBoolean(IGNORE_FILES_WITHOUT_EXTENSION_KEY, true)) {
            ArrayList<FileStatus> result = new ArrayList<FileStatus>(status.length);
            for (FileStatus file : status) {
                if (!file.getPath().getName().endsWith(".avro")) continue;
                result.add(file);
            }
            status = result.toArray(new FileStatus[0]);
        }
        return status;
    }

    @Override
    public RecordReader<AvroWrapper<T>, NullWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new AvroRecordReader(job, (FileSplit)split);
    }
}

