/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.thrift.ThriftDatumReader;
import org.apache.avro.thrift.ThriftDatumWriter;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;

public class ThriftData
extends GenericData {
    static final String THRIFT_TYPE = "thrift";
    static final String THRIFT_PROP = "thrift";
    private static final ThriftData INSTANCE = new ThriftData();
    private final Map<Schema, TFieldIdEnum[]> fieldCache = new ConcurrentHashMap<Schema, TFieldIdEnum[]>();
    private final Map<Class, Schema> schemaCache = new ConcurrentHashMap<Class, Schema>();
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);

    protected ThriftData() {
    }

    public static ThriftData get() {
        return INSTANCE;
    }

    public DatumReader createDatumReader(Schema schema) {
        return new ThriftDatumReader(schema, schema, this);
    }

    public DatumWriter createDatumWriter(Schema schema) {
        return new ThriftDatumWriter(schema, this);
    }

    public void setField(Object r, String n, int pos, Object o) {
        this.setField(r, n, pos, o, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    public Object getField(Object r, String name, int pos) {
        return this.getField(r, name, pos, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    protected void setField(Object r, String n, int pos, Object v, Object state) {
        ((TBase)r).setFieldValue(((TFieldIdEnum[])state)[pos], v);
    }

    protected Object getField(Object record, String name, int pos, Object state) {
        TBase struct = (TBase)record;
        TFieldIdEnum f = ((TFieldIdEnum[])state)[pos];
        if (struct.isSet(f)) {
            return struct.getFieldValue(f);
        }
        return null;
    }

    protected Object getRecordState(Object r, Schema s) {
        TFieldIdEnum[] fields = this.fieldCache.get(s);
        if (fields == null) {
            fields = new TFieldIdEnum[s.getFields().size()];
            Class<?> c = r.getClass();
            Iterator i$ = FieldMetaData.getStructMetaDataMap(c).keySet().iterator();
            while (i$.hasNext()) {
                TFieldIdEnum f;
                fields[s.getField((String)f.getFieldName()).pos()] = f = (TFieldIdEnum)i$.next();
            }
            this.fieldCache.put(s, fields);
        }
        return fields;
    }

    protected boolean isRecord(Object datum) {
        return datum instanceof TBase && !(datum instanceof TUnion);
    }

    protected boolean isEnum(Object datum) {
        return datum instanceof TEnum;
    }

    protected Schema getEnumSchema(Object datum) {
        return this.getSchema(datum.getClass());
    }

    protected boolean isBytes(Object datum) {
        if (datum instanceof ByteBuffer) {
            return true;
        }
        if (datum == null) {
            return false;
        }
        Class<?> c = datum.getClass();
        return c.isArray() && c.getComponentType() == Byte.TYPE;
    }

    public Object newRecord(Object old, Schema schema) {
        try {
            Class<?> c = Class.forName(SpecificData.getClassName((Schema)schema));
            if (c == null) {
                return this.newRecord(old, schema);
            }
            if (c.isInstance(old)) {
                return old;
            }
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Schema getRecordSchema(Object record) {
        return this.getSchema(record.getClass());
    }

    public Schema getSchema(Class c) {
        Schema schema = this.schemaCache.get(c);
        if (schema == null) {
            block8: {
                try {
                    if (TEnum.class.isAssignableFrom(c)) {
                        ArrayList<String> symbols = new ArrayList<String>();
                        for (Enum e : (Enum[])c.getEnumConstants()) {
                            symbols.add(e.name());
                        }
                        schema = Schema.createEnum((String)c.getName(), null, null, symbols);
                        break block8;
                    }
                    if (TBase.class.isAssignableFrom(c)) {
                        schema = Schema.createRecord((String)c.getName(), null, null, (boolean)Throwable.class.isAssignableFrom(c));
                        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                        for (FieldMetaData f : FieldMetaData.getStructMetaDataMap((Class)c).values()) {
                            Schema s = this.getSchema(f.valueMetaData);
                            if (f.requirementType == 2 && s.getType() != Schema.Type.UNION) {
                                s = this.nullable(s);
                            }
                            fields.add(new Schema.Field(f.fieldName, s, null, null));
                        }
                        schema.setFields(fields);
                        break block8;
                    }
                    throw new RuntimeException("Not a Thrift-generated class: " + c);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.schemaCache.put(c, schema);
        }
        return schema;
    }

    private Schema getSchema(FieldValueMetaData f) {
        switch (f.type) {
            case 2: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case 3: {
                Schema b = Schema.create((Schema.Type)Schema.Type.INT);
                b.addProp("thrift", "byte");
                return b;
            }
            case 6: {
                Schema s = Schema.create((Schema.Type)Schema.Type.INT);
                s.addProp("thrift", "short");
                return s;
            }
            case 8: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case 10: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case 4: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case 16: {
                EnumMetaData enumMeta = (EnumMetaData)f;
                return this.nullable(this.getSchema(enumMeta.enumClass));
            }
            case 15: {
                ListMetaData listMeta = (ListMetaData)f;
                return this.nullable(Schema.createArray((Schema)this.getSchema(listMeta.elemMetaData)));
            }
            case 13: {
                MapMetaData mapMeta = (MapMetaData)f;
                if (mapMeta.keyMetaData.type != 11) {
                    throw new AvroRuntimeException("Map keys must be strings: " + f);
                }
                Schema map = Schema.createMap((Schema)this.getSchema(mapMeta.valueMetaData));
                GenericData.setStringType((Schema)map, (GenericData.StringType)GenericData.StringType.String);
                return this.nullable(map);
            }
            case 14: {
                SetMetaData setMeta = (SetMetaData)f;
                Schema set = Schema.createArray((Schema)this.getSchema(setMeta.elemMetaData));
                set.addProp("thrift", "set");
                return this.nullable(set);
            }
            case 11: {
                if (f.isBinary()) {
                    return this.nullable(Schema.create((Schema.Type)Schema.Type.BYTES));
                }
                Schema string = Schema.create((Schema.Type)Schema.Type.STRING);
                GenericData.setStringType((Schema)string, (GenericData.StringType)GenericData.StringType.String);
                return this.nullable(string);
            }
            case 12: {
                StructMetaData structMeta = (StructMetaData)f;
                Schema record = this.getSchema(structMeta.structClass);
                return this.nullable(record);
            }
            case 1: {
                return NULL;
            }
        }
        throw new RuntimeException("Unexpected type in field: " + f);
    }

    private Schema nullable(Schema schema) {
        return Schema.createUnion(Arrays.asList(NULL, schema));
    }
}

