/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.thrift;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.thrift.ThriftData;

public class ThriftDatumReader<T>
extends GenericDatumReader<T> {
    public ThriftDatumReader() {
        this(null, null, ThriftData.get());
    }

    public ThriftDatumReader(Class<T> c) {
        this(ThriftData.get().getSchema(c));
    }

    public ThriftDatumReader(Schema schema) {
        this(schema, schema, ThriftData.get());
    }

    public ThriftDatumReader(Schema writer, Schema reader) {
        this(writer, reader, ThriftData.get());
    }

    protected ThriftDatumReader(Schema writer, Schema reader, ThriftData data) {
        super(writer, reader, (GenericData)data);
    }

    protected Object createEnum(String symbol, Schema schema) {
        try {
            Class<?> c = Class.forName(SpecificData.getClassName((Schema)schema));
            if (c == null) {
                return super.createEnum(symbol, schema);
            }
            return Enum.valueOf(c, symbol);
        }
        catch (Exception e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    protected Object readInt(Object old, Schema s, Decoder in) throws IOException {
        String type = s.getProp("thrift");
        int value = in.readInt();
        if (type != null) {
            if ("byte".equals(type)) {
                return (byte)value;
            }
            if ("short".equals(type)) {
                return (short)value;
            }
        }
        return value;
    }

    protected Object newArray(Object old, int size, Schema schema) {
        if ("set".equals(schema.getProp("thrift"))) {
            if (old instanceof Set) {
                ((Set)old).clear();
                return old;
            }
            return new HashSet();
        }
        return super.newArray(old, size, schema);
    }
}

