/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroFiles;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyValueInputFormat;
import org.apache.avro.mapreduce.AvroKeyValueOutputFormat;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestKeyValueInput {
    @Rule
    public TemporaryFolder mTempDir = new TemporaryFolder();

    private File createInputFile() throws IOException {
        Schema keyValueSchema = AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.INT), (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroKeyValue record1 = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        record1.setKey((Object)1);
        record1.setValue((Object)"apple banana carrot");
        AvroKeyValue record2 = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        record2.setKey((Object)2);
        record2.setValue((Object)"apple banana");
        AvroKeyValue record3 = new AvroKeyValue((GenericRecord)new GenericData.Record(keyValueSchema));
        record3.setKey((Object)3);
        record3.setValue((Object)"apple");
        return AvroFiles.createFile(new File(this.mTempDir.getRoot(), "inputKeyValues.avro"), keyValueSchema, record1.get(), record2.get(), record3.get());
    }

    @Test
    public void testKeyValueInput() throws ClassNotFoundException, IOException, InterruptedException {
        File inputFile = this.createInputFile();
        Job job = new Job();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputFile.getAbsolutePath())});
        job.setInputFormatClass(AvroKeyValueInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroJob.setInputValueSchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        job.setMapperClass(IndexMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(IndexReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(AvroValue.class);
        AvroJob.setOutputValueSchema((Job)job, (Schema)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)));
        job.setOutputFormatClass(AvroKeyValueOutputFormat.class);
        Path outputPath = new Path(this.mTempDir.getRoot().getPath(), "out-index");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        File avroFile = new File(outputPath.toString(), "part-r-00000.avro");
        SpecificDatumReader datumReader = new SpecificDatumReader(AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.STRING), (Schema)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT))));
        DataFileReader avroFileReader = new DataFileReader(avroFile, (DatumReader)datumReader);
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue appleRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertNotNull((Object)appleRecord.get());
        Assert.assertEquals((Object)"apple", (Object)((CharSequence)appleRecord.getKey()).toString());
        List appleDocs = (List)appleRecord.getValue();
        Assert.assertEquals((long)3L, (long)appleDocs.size());
        Assert.assertTrue((boolean)appleDocs.contains(1));
        Assert.assertTrue((boolean)appleDocs.contains(2));
        Assert.assertTrue((boolean)appleDocs.contains(3));
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue bananaRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertNotNull((Object)bananaRecord.get());
        Assert.assertEquals((Object)"banana", (Object)((CharSequence)bananaRecord.getKey()).toString());
        List bananaDocs = (List)bananaRecord.getValue();
        Assert.assertEquals((long)2L, (long)bananaDocs.size());
        Assert.assertTrue((boolean)bananaDocs.contains(1));
        Assert.assertTrue((boolean)bananaDocs.contains(2));
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue carrotRecord = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertEquals((Object)"carrot", (Object)((CharSequence)carrotRecord.getKey()).toString());
        List carrotDocs = (List)carrotRecord.getValue();
        Assert.assertEquals((long)1L, (long)carrotDocs.size());
        Assert.assertTrue((boolean)carrotDocs.contains(1));
        Assert.assertFalse((boolean)avroFileReader.hasNext());
        avroFileReader.close();
    }

    @Test
    public void testKeyValueInputMapOnly() throws ClassNotFoundException, IOException, InterruptedException {
        File inputFile = this.createInputFile();
        Job job = new Job();
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputFile.getAbsolutePath())});
        job.setInputFormatClass(AvroKeyValueInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroJob.setInputValueSchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroJob.setMapOutputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.INT));
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(AvroKey.class);
        job.setOutputValueClass(AvroValue.class);
        job.setOutputFormatClass(AvroKeyValueOutputFormat.class);
        Path outputPath = new Path(this.mTempDir.getRoot().getPath(), "out-index");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        File avroFile = new File(outputPath.toString(), "part-m-00000.avro");
        SpecificDatumReader datumReader = new SpecificDatumReader(AvroKeyValue.getSchema((Schema)Schema.create((Schema.Type)Schema.Type.INT), (Schema)Schema.create((Schema.Type)Schema.Type.STRING)));
        DataFileReader avroFileReader = new DataFileReader(avroFile, (DatumReader)datumReader);
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue record1 = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertNotNull((Object)record1.get());
        Assert.assertEquals((long)1L, (long)((Integer)record1.getKey()).intValue());
        Assert.assertEquals((Object)"apple banana carrot", (Object)((CharSequence)record1.getValue()).toString());
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue record2 = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertNotNull((Object)record2.get());
        Assert.assertEquals((long)2L, (long)((Integer)record2.getKey()).intValue());
        Assert.assertEquals((Object)"apple banana", (Object)((CharSequence)record2.getValue()).toString());
        Assert.assertTrue((boolean)avroFileReader.hasNext());
        AvroKeyValue record3 = new AvroKeyValue((GenericRecord)avroFileReader.next());
        Assert.assertNotNull((Object)record3.get());
        Assert.assertEquals((long)3L, (long)((Integer)record3.getKey()).intValue());
        Assert.assertEquals((Object)"apple", (Object)((CharSequence)record3.getValue()).toString());
        Assert.assertFalse((boolean)avroFileReader.hasNext());
        avroFileReader.close();
    }

    public static class IndexReducer
    extends Reducer<Text, IntWritable, Text, AvroValue<List<Integer>>> {
        protected void reduce(Text token, Iterable<IntWritable> docids, Reducer.Context context) throws IOException, InterruptedException {
            ArrayList<Integer> hitlist = new ArrayList<Integer>();
            for (IntWritable docid : docids) {
                hitlist.add(docid.get());
            }
            context.write((Object)token, (Object)new AvroValue(hitlist));
        }
    }

    public static class IndexMapper
    extends Mapper<AvroKey<Integer>, AvroValue<CharSequence>, Text, IntWritable> {
        protected void map(AvroKey<Integer> docid, AvroValue<CharSequence> body, Mapper.Context context) throws IOException, InterruptedException {
            for (String token : ((CharSequence)body.datum()).toString().split(" ")) {
                context.write((Object)new Text(token), (Object)new IntWritable(((Integer)docid.datum()).intValue()));
            }
        }
    }
}

