/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.util.StringTokenizer;
import junit.framework.Assert;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroRecordReader;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.junit.Test;

public class TestWordCount {
    @Test
    public void runTestsInOrder() throws Exception {
        this.testJob();
        this.testProjection();
    }

    public void testJob() throws Exception {
        JobConf job = new JobConf();
        String dir = System.getProperty("test.dir", ".") + "/mapred";
        Path outputPath = new Path(dir + "/out");
        outputPath.getFileSystem((Configuration)job).delete(outputPath);
        WordCountUtil.writeLinesFile();
        job.setJobName("wordcount");
        AvroJob.setInputSchema((JobConf)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        AvroJob.setOutputSchema((JobConf)job, (Schema)new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema());
        AvroJob.setMapperClass((JobConf)job, MapImpl.class);
        AvroJob.setCombinerClass((JobConf)job, ReduceImpl.class);
        AvroJob.setReducerClass((JobConf)job, ReduceImpl.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(dir + "/in")});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        WordCountUtil.setMeta(job);
        JobClient.runJob((JobConf)job);
        WordCountUtil.validateCountsFile();
    }

    public void testProjection() throws Exception {
        JobConf job = new JobConf();
        Integer defaultRank = new Integer(-1);
        String jsonSchema = "{\"type\":\"record\",\"name\":\"org.apache.avro.mapred.Pair\",\"fields\": [ {\"name\":\"rank\", \"type\":\"int\", \"default\": -1},{\"name\":\"value\", \"type\":\"long\"}]}";
        Schema readerSchema = Schema.parse((String)jsonSchema);
        AvroJob.setInputSchema((JobConf)job, (Schema)readerSchema);
        String dir = System.getProperty("test.dir", ".") + "/mapred";
        Path inputPath = new Path(dir + "/out" + "/part-00000" + ".avro");
        FileStatus fileStatus = FileSystem.get((Configuration)job).getFileStatus(inputPath);
        FileSplit fileSplit = new FileSplit(inputPath, 0L, fileStatus.getLen(), job);
        AvroRecordReader recordReader = new AvroRecordReader(job, fileSplit);
        AvroWrapper inputPair = new AvroWrapper(null);
        NullWritable ignore = NullWritable.get();
        long sumOfCounts = 0L;
        long numOfCounts = 0L;
        while (recordReader.next(inputPair, ignore)) {
            Assert.assertEquals((Object)((Integer)((Pair)inputPair.datum()).get(0)), (Object)defaultRank);
            sumOfCounts += ((Long)((Pair)inputPair.datum()).get(1)).longValue();
            ++numOfCounts;
        }
        Assert.assertEquals((long)numOfCounts, (long)WordCountUtil.COUNTS.size());
        long actualSumOfCounts = 0L;
        for (Long count : WordCountUtil.COUNTS.values()) {
            actualSumOfCounts += count.longValue();
        }
        Assert.assertEquals((long)sumOfCounts, (long)actualSumOfCounts);
    }

    public static class ReduceImpl
    extends AvroReducer<Utf8, Long, Pair<Utf8, Long>> {
        public void reduce(Utf8 word, Iterable<Long> counts, AvroCollector<Pair<Utf8, Long>> collector, Reporter reporter) throws IOException {
            long sum = 0L;
            for (long count : counts) {
                sum += count;
            }
            collector.collect((Object)new Pair((CharSequence)word, Long.valueOf(sum)));
        }
    }

    public static class MapImpl
    extends AvroMapper<Utf8, Pair<Utf8, Long>> {
        public void map(Utf8 text, AvroCollector<Pair<Utf8, Long>> collector, Reporter reporter) throws IOException {
            StringTokenizer tokens = new StringTokenizer(text.toString());
            while (tokens.hasMoreTokens()) {
                collector.collect((Object)new Pair((CharSequence)new Utf8(tokens.nextToken()), Long.valueOf(1L)));
            }
        }
    }
}

