/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.SequenceFileReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSequenceFileReader {
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "10"));
    private static final File DIR = new File(System.getProperty("test.dir", "."));
    private static final File FILE = new File(DIR, "test.seq");
    private static final Schema SCHEMA = Pair.getPairSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG), (Schema)Schema.create((Schema.Type)Schema.Type.STRING));

    @BeforeClass
    public static void testWriteSequenceFile() throws IOException {
        FILE.delete();
        Configuration c = new Configuration();
        URI uri = FILE.toURI();
        SequenceFile.Writer writer = new SequenceFile.Writer(FileSystem.get((URI)uri, (Configuration)c), c, new Path(uri.toString()), LongWritable.class, Text.class);
        LongWritable key = new LongWritable();
        Text val = new Text();
        for (int i = 0; i < COUNT; ++i) {
            key.set((long)i);
            val.set(Integer.toString(i));
            writer.append((Writable)key, (Writable)val);
        }
        writer.close();
    }

    @Test
    public void testReadSequenceFile() throws Exception {
        this.checkFile((FileReader<Pair<Long, CharSequence>>)new SequenceFileReader(FILE));
    }

    public void checkFile(FileReader<Pair<Long, CharSequence>> reader) throws Exception {
        long i = 0L;
        for (Pair p : reader) {
            Assert.assertEquals((Object)i, (Object)p.key());
            Assert.assertEquals((Object)Long.toString(i), (Object)((CharSequence)p.value()).toString());
            ++i;
        }
        Assert.assertEquals((long)COUNT, (long)i);
        reader.close();
    }

    @Test
    public void testSequenceFileInputFormat() throws Exception {
        JobConf job = new JobConf();
        Path output = new Path(System.getProperty("test.dir", ".") + "/seq-out");
        output.getFileSystem((Configuration)job).delete(output);
        AvroJob.setInputSequenceFile((JobConf)job);
        FileInputFormat.setInputPaths((JobConf)job, (String)FILE.toURI().toString());
        AvroJob.setInputSchema((JobConf)job, (Schema)SCHEMA);
        AvroJob.setOutputSchema((JobConf)job, (Schema)SCHEMA);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)output);
        JobClient.runJob((JobConf)job);
        this.checkFile((FileReader<Pair<Long, CharSequence>>)new DataFileReader(new File(output.toString() + "/part-00000.avro"), (DatumReader)new SpecificDatumReader()));
    }

    @Test
    public void testNonAvroMapper() throws Exception {
        JobConf job = new JobConf();
        Path output = new Path(System.getProperty("test.dir", ".") + "/seq-out");
        output.getFileSystem((Configuration)job).delete(output);
        job.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)job, (String)FILE.toURI().toString());
        job.setMapperClass(NonAvroMapper.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)output);
        AvroJob.setOutputSchema((JobConf)job, (Schema)SCHEMA);
        JobClient.runJob((JobConf)job);
        this.checkFile((FileReader<Pair<Long, CharSequence>>)new DataFileReader(new File(output.toString() + "/part-00000.avro"), (DatumReader)new SpecificDatumReader()));
    }

    @Test
    public void testNonAvroMapOnly() throws Exception {
        JobConf job = new JobConf();
        Path output = new Path(System.getProperty("test.dir", ".") + "/seq-out");
        output.getFileSystem((Configuration)job).delete(output);
        job.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)job, (String)FILE.toURI().toString());
        job.setMapperClass(NonAvroOnlyMapper.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)output);
        AvroJob.setOutputSchema((JobConf)job, (Schema)SCHEMA);
        JobClient.runJob((JobConf)job);
        this.checkFile((FileReader<Pair<Long, CharSequence>>)new DataFileReader(new File(output.toString() + "/part-00000.avro"), (DatumReader)new SpecificDatumReader()));
    }

    @Test
    public void testNonAvroReducer() throws Exception {
        JobConf job = new JobConf();
        Path output = new Path(System.getProperty("test.dir", ".") + "/seq-out");
        output.getFileSystem((Configuration)job).delete(output);
        AvroJob.setInputSequenceFile((JobConf)job);
        AvroJob.setInputSchema((JobConf)job, (Schema)SCHEMA);
        FileInputFormat.setInputPaths((JobConf)job, (String)FILE.toURI().toString());
        AvroJob.setMapOutputSchema((JobConf)job, (Schema)SCHEMA);
        job.setReducerClass(NonAvroReducer.class);
        job.setOutputFormat(SequenceFileOutputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)output);
        JobClient.runJob((JobConf)job);
        this.checkFile((FileReader<Pair<Long, CharSequence>>)new SequenceFileReader(new File(output.toString() + "/part-00000")));
    }

    private static class NonAvroReducer
    extends MapReduceBase
    implements Reducer<AvroKey<Long>, AvroValue<Utf8>, LongWritable, Text> {
        private NonAvroReducer() {
        }

        public void reduce(AvroKey<Long> key, Iterator<AvroValue<Utf8>> values, OutputCollector<LongWritable, Text> out, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                AvroValue<Utf8> value = values.next();
                out.collect((Object)new LongWritable(((Long)key.datum()).longValue()), (Object)new Text(((Utf8)value.datum()).toString()));
            }
        }
    }

    private static class NonAvroOnlyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, AvroWrapper<Pair<Long, Utf8>>, NullWritable> {
        private NonAvroOnlyMapper() {
        }

        public void map(LongWritable key, Text value, OutputCollector<AvroWrapper<Pair<Long, Utf8>>, NullWritable> out, Reporter reporter) throws IOException {
            out.collect((Object)new AvroWrapper((Object)new Pair(Long.valueOf(key.get()), (CharSequence)new Utf8(value.toString()))), (Object)NullWritable.get());
        }
    }

    private static class NonAvroMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, AvroKey<Long>, AvroValue<Utf8>> {
        private NonAvroMapper() {
        }

        public void map(LongWritable key, Text value, OutputCollector<AvroKey<Long>, AvroValue<Utf8>> out, Reporter reporter) throws IOException {
            out.collect((Object)new AvroKey((Object)key.get()), (Object)new AvroValue((Object)new Utf8(value.toString())));
        }
    }
}

