/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Test;

public class TestAvroOutputFormat
extends TestCase {
    @Test
    public void testSetSyncInterval() {
        JobConf jobConf = new JobConf();
        int newSyncInterval = 100000;
        AvroOutputFormat.setSyncInterval((JobConf)jobConf, (int)newSyncInterval);
        TestAvroOutputFormat.assertEquals((int)newSyncInterval, (int)jobConf.getInt("avro.mapred.sync.interval", -1));
    }

    @Test
    public void testNoCodec() throws UnsupportedEncodingException {
        JobConf job = new JobConf();
        TestAvroOutputFormat.assertTrue((AvroOutputFormat.getCodecFactory((JobConf)job) == null ? 1 : 0) != 0);
        job = new JobConf();
        job.set("mapred.output.compress", "false");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        TestAvroOutputFormat.assertTrue((AvroOutputFormat.getCodecFactory((JobConf)job) == null ? 1 : 0) != 0);
        job = new JobConf();
        job.set("mapred.output.compress", "false");
        job.set("avro.output.codec", "bzip2");
        TestAvroOutputFormat.assertTrue((AvroOutputFormat.getCodecFactory((JobConf)job) == null ? 1 : 0) != 0);
    }

    @Test
    public void testBZip2CodecUsingHadoopClass() throws UnsupportedEncodingException {
        CodecFactory avroBZip2Codec = CodecFactory.fromString((String)"bzip2");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        TestAvroOutputFormat.assertTrue((factory != null ? 1 : 0) != 0);
        TestAvroOutputFormat.assertTrue((boolean)factory.getClass().equals(avroBZip2Codec.getClass()));
    }

    @Test
    public void testBZip2CodecUsingAvroCodec() throws UnsupportedEncodingException {
        CodecFactory avroBZip2Codec = CodecFactory.fromString((String)"bzip2");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "bzip2");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        TestAvroOutputFormat.assertTrue((factory != null ? 1 : 0) != 0);
        TestAvroOutputFormat.assertTrue((boolean)factory.getClass().equals(avroBZip2Codec.getClass()));
    }

    @Test
    public void testDeflateCodecUsingHadoopClass() throws UnsupportedEncodingException {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.DeflateCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        TestAvroOutputFormat.assertTrue((factory != null ? 1 : 0) != 0);
        TestAvroOutputFormat.assertTrue((boolean)factory.getClass().equals(avroDeflateCodec.getClass()));
    }

    @Test
    public void testDeflateCodecUsingAvroCodec() throws UnsupportedEncodingException {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "deflate");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        TestAvroOutputFormat.assertTrue((factory != null ? 1 : 0) != 0);
        TestAvroOutputFormat.assertTrue((boolean)factory.getClass().equals(avroDeflateCodec.getClass()));
    }

    @Test
    public void testSnappyCodecUsingHadoopClass() throws UnsupportedEncodingException {
        CodecFactory avroSnappyCodec = CodecFactory.fromString((String)"snappy");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.SnappyCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        TestAvroOutputFormat.assertTrue((factory != null ? 1 : 0) != 0);
        TestAvroOutputFormat.assertTrue((boolean)factory.getClass().equals(avroSnappyCodec.getClass()));
    }

    @Test
    public void testSnappyCodecUsingAvroCodec() throws UnsupportedEncodingException {
        CodecFactory avroSnappyCodec = CodecFactory.fromString((String)"snappy");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "snappy");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        TestAvroOutputFormat.assertTrue((factory != null ? 1 : 0) != 0);
        TestAvroOutputFormat.assertTrue((boolean)factory.getClass().equals(avroSnappyCodec.getClass()));
    }

    @Test
    public void testGZipCodecUsingHadoopClass() throws UnsupportedEncodingException {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.GZipCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        TestAvroOutputFormat.assertTrue((factory != null ? 1 : 0) != 0);
        TestAvroOutputFormat.assertTrue((boolean)factory.getClass().equals(avroDeflateCodec.getClass()));
    }
}

