/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.util.HashSet;
import junit.framework.Assert;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestAvroInputFormat {
    private static final String TEST_DIR = System.getProperty("test.dir", ".") + File.separator + TestAvroInputFormat.class.getName();
    private JobConf conf;
    private FileSystem fs;
    private Path inputDir;

    @Before
    public void setUp() throws Exception {
        this.conf = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.inputDir = new Path(TEST_DIR);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(this.inputDir, true);
    }

    @Test
    public void testIgnoreFilesWithoutExtension() throws Exception {
        this.fs.mkdirs(this.inputDir);
        Path avroFile = new Path(this.inputDir, "somefile.avro");
        Path textFile = new Path(this.inputDir, "someotherfile.txt");
        this.fs.create(avroFile).close();
        this.fs.create(textFile).close();
        FileInputFormat.setInputPaths((JobConf)this.conf, (Path[])new Path[]{this.inputDir});
        AvroInputFormat inputFormat = new AvroInputFormat();
        FileStatus[] statuses = inputFormat.listStatus(this.conf);
        Assert.assertEquals((int)1, (int)statuses.length);
        Assert.assertEquals((String)"somefile.avro", (String)statuses[0].getPath().getName());
        this.conf.setBoolean("avro.mapred.ignore.inputs.without.extension", false);
        statuses = inputFormat.listStatus(this.conf);
        Assert.assertEquals((int)2, (int)statuses.length);
        HashSet<String> names = new HashSet<String>();
        names.add(statuses[0].getPath().getName());
        names.add(statuses[1].getPath().getName());
        Assert.assertTrue((boolean)names.contains("somefile.avro"));
        Assert.assertTrue((boolean)names.contains("someotherfile.txt"));
    }
}

