/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasImportRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TRANSFORMS_KEY = "transforms";
    public static final String TRANSFORMERS_KEY = "transformers";
    public static final String OPTION_KEY_REPLICATED_FROM = "replicatedFrom";
    public static final String OPTION_KEY_MIGRATION_FILE_NAME = "migrationFileName";
    public static final String OPTION_KEY_MIGRATION = "migration";
    public static final String OPTION_KEY_NUM_WORKERS = "numWorkers";
    public static final String OPTION_KEY_BATCH_SIZE = "batchSize";
    public static final String OPTION_KEY_FORMAT = "format";
    public static final String OPTION_KEY_FORMAT_ZIP_DIRECT = "zipDirect";
    public static final String START_POSITION_KEY = "startPosition";
    public static final String UPDATE_TYPE_DEFINITION_KEY = "updateTypeDefinition";
    private static final String START_GUID_KEY = "startGuid";
    private static final String FILE_NAME_KEY = "fileName";
    private static final String OPTION_KEY_STREAM_SIZE = "size";
    private Map<String, String> options = new HashMap<String, String>();

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasImportRequest{");
        sb.append("options={");
        AtlasBaseTypeDef.dumpObjects(this.options, sb);
        sb.append("}");
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonIgnore
    public String getStartGuid() {
        return this.getOptionForKey(START_GUID_KEY);
    }

    @JsonIgnore
    public String getFileName() {
        return this.getOptionForKey(FILE_NAME_KEY);
    }

    @JsonIgnore
    public void setFileName(String fileName) {
        this.setOption(FILE_NAME_KEY, fileName);
    }

    @JsonIgnore
    public String getStartPosition() {
        return this.getOptionForKey(START_POSITION_KEY);
    }

    @JsonIgnore
    public String getUpdateTypeDefs() {
        return this.getOptionForKey(UPDATE_TYPE_DEFINITION_KEY);
    }

    private String getOptionForKey(String key) {
        if (MapUtils.isEmpty(this.options) || !this.options.containsKey(key)) {
            return null;
        }
        return this.options.get(key);
    }

    @JsonIgnore
    public boolean isReplicationOptionSet() {
        return MapUtils.isNotEmpty(this.options) && this.options.containsKey(OPTION_KEY_REPLICATED_FROM);
    }

    @JsonIgnore
    public String getOptionKeyReplicatedFrom() {
        return this.isReplicationOptionSet() ? this.options.get(OPTION_KEY_REPLICATED_FROM) : "";
    }

    @JsonIgnore
    public int getOptionKeyNumWorkers() {
        return this.getOptionsValue(OPTION_KEY_NUM_WORKERS, 1);
    }

    @JsonIgnore
    public int getOptionKeyBatchSize() {
        return this.getOptionsValue(OPTION_KEY_BATCH_SIZE, 1);
    }

    private int getOptionsValue(String optionKeyBatchSize, int defaultValue) {
        String optionsValue = this.getOptionForKey(optionKeyBatchSize);
        return StringUtils.isEmpty((String)optionsValue) ? defaultValue : Integer.valueOf(optionsValue);
    }

    @JsonAnySetter
    public void setOption(String key, String value) {
        if (null == this.options) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, value);
    }

    public void setSizeOption(int size) {
        this.setOption(OPTION_KEY_STREAM_SIZE, Integer.toString(size));
    }

    public int getSizeOption() {
        if (!this.options.containsKey(OPTION_KEY_STREAM_SIZE)) {
            return 1;
        }
        return Integer.valueOf(this.options.get(OPTION_KEY_STREAM_SIZE));
    }
}

