
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.arrow.vector.complex.impl;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.flatbuffers.FlatBufferBuilder;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.arrow.memory.*;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.Types.*;
import org.apache.arrow.vector.types.pojo.*;
import org.apache.arrow.vector.types.pojo.ArrowType.*;
import org.apache.arrow.vector.types.*;
import org.apache.arrow.vector.*;
import org.apache.arrow.vector.holders.*;
import org.apache.arrow.vector.util.*;
import org.apache.arrow.vector.complex.*;
import org.apache.arrow.vector.complex.reader.*;
import org.apache.arrow.vector.complex.impl.*;
import org.apache.arrow.vector.complex.writer.*;
import org.apache.arrow.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.arrow.vector.util.JsonStringArrayList;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;






import java.util.Map;

import org.apache.arrow.vector.holders.RepeatedMapHolder;
import org.apache.arrow.vector.AllocationHelper;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.FieldWriter;

import com.google.common.collect.Maps;

/*
 * This class is generated using FreeMarker and the MapWriters.java template.
 */
@SuppressWarnings("unused")
public class NullableMapWriter extends AbstractFieldWriter {

  protected final NullableMapVector container;
  private final Map<String, FieldWriter> fields = Maps.newHashMap();

  public NullableMapWriter(NullableMapVector container) {
    this.container = container;
    for (Field child : container.getField().getChildren()) {
      switch (Types.getMinorTypeForArrowType(child.getType())) {
      case MAP:
        map(child.getName());
        break;
      case LIST:
        list(child.getName());
        break;
      case UNION:
        UnionWriter writer = new UnionWriter(container.addOrGet(child.getName(), MinorType.UNION, UnionVector.class));
        fields.put(child.getName().toLowerCase(), writer);
        break;
      case TINYINT:
        tinyInt(child.getName());
        break;
      case UINT1:
        uInt1(child.getName());
        break;
      case UINT2:
        uInt2(child.getName());
        break;
      case SMALLINT:
        smallInt(child.getName());
        break;
      case INT:
        integer(child.getName());
        break;
      case UINT4:
        uInt4(child.getName());
        break;
      case FLOAT4:
        float4(child.getName());
        break;
      case INTERVALYEAR:
        intervalYear(child.getName());
        break;
      case TIME:
        time(child.getName());
        break;
      case BIGINT:
        bigInt(child.getName());
        break;
      case UINT8:
        uInt8(child.getName());
        break;
      case FLOAT8:
        float8(child.getName());
        break;
      case DATE:
        date(child.getName());
        break;
      case TIMESTAMP:
        timeStamp(child.getName());
        break;
      case INTERVALDAY:
        intervalDay(child.getName());
        break;
      case DECIMAL:
        decimal(child.getName());
        break;
      case VARBINARY:
        varBinary(child.getName());
        break;
      case VARCHAR:
        varChar(child.getName());
        break;
      case BIT:
        bit(child.getName());
        break;
      }
    }
  }

  @Override
  public int getValueCapacity() {
    return container.getValueCapacity();
  }

  @Override
  public boolean isEmptyMap() {
    return 0 == container.size();
  }

  @Override
  public Field getField() {
      return container.getField();
  }

  @Override
  public MapWriter map(String name) {
      FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null){
      int vectorCount=container.size();
      NullableMapVector vector = container.addOrGet(name, MinorType.MAP, NullableMapVector.class);
      writer = new PromotableWriter(vector, container);
      if(vectorCount != container.size()) {
        writer.allocate();
      }
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }

  @Override
  public void close() throws Exception {
    clear();
    container.close();
  }

  @Override
  public void allocate() {
    container.allocateNew();
    for(final FieldWriter w : fields.values()) {
      w.allocate();
    }
  }

  @Override
  public void clear() {
    container.clear();
    for(final FieldWriter w : fields.values()) {
      w.clear();
    }
  }

  @Override
  public ListWriter list(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    int vectorCount = container.size();
    if(writer == null) {
      writer = new PromotableWriter(container.addOrGet(name, MinorType.LIST, ListVector.class), container);
      if (container.size() > vectorCount) {
        writer.allocate();
      }
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }

  public void setValueCount(int count) {
    container.getMutator().setValueCount(count);
  }

  @Override
  public void setPosition(int index) {
    super.setPosition(index);
    for(final FieldWriter w: fields.values()) {
      w.setPosition(index);
    }
  }

  @Override
  public void start() {
    container.getMutator().setIndexDefined(idx());
  }

  @Override
  public void end() {
  }


  @Override
  public TinyIntWriter tinyInt(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableTinyIntVector v = container.addOrGet(name, MinorType.TINYINT, NullableTinyIntVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public UInt1Writer uInt1(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableUInt1Vector v = container.addOrGet(name, MinorType.UINT1, NullableUInt1Vector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public UInt2Writer uInt2(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableUInt2Vector v = container.addOrGet(name, MinorType.UINT2, NullableUInt2Vector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public SmallIntWriter smallInt(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableSmallIntVector v = container.addOrGet(name, MinorType.SMALLINT, NullableSmallIntVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public IntWriter integer(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableIntVector v = container.addOrGet(name, MinorType.INT, NullableIntVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public UInt4Writer uInt4(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableUInt4Vector v = container.addOrGet(name, MinorType.UINT4, NullableUInt4Vector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public Float4Writer float4(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableFloat4Vector v = container.addOrGet(name, MinorType.FLOAT4, NullableFloat4Vector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public IntervalYearWriter intervalYear(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableIntervalYearVector v = container.addOrGet(name, MinorType.INTERVALYEAR, NullableIntervalYearVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public TimeWriter time(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableTimeVector v = container.addOrGet(name, MinorType.TIME, NullableTimeVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public BigIntWriter bigInt(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableBigIntVector v = container.addOrGet(name, MinorType.BIGINT, NullableBigIntVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public UInt8Writer uInt8(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableUInt8Vector v = container.addOrGet(name, MinorType.UINT8, NullableUInt8Vector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public Float8Writer float8(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableFloat8Vector v = container.addOrGet(name, MinorType.FLOAT8, NullableFloat8Vector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public DateWriter date(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableDateVector v = container.addOrGet(name, MinorType.DATE, NullableDateVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public TimeStampWriter timeStamp(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableTimeStampVector v = container.addOrGet(name, MinorType.TIMESTAMP, NullableTimeStampVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public IntervalDayWriter intervalDay(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableIntervalDayVector v = container.addOrGet(name, MinorType.INTERVALDAY, NullableIntervalDayVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  public DecimalWriter decimal(String name) {
    // returns existing writer
    final FieldWriter writer = fields.get(name.toLowerCase());
    assert writer != null;
    return writer;
  }

  public DecimalWriter decimal(String name, int scale, int precision) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableDecimalVector v = container.addOrGet(name, MinorType.DECIMAL, NullableDecimalVector.class , new int[] {precision, scale});
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public VarBinaryWriter varBinary(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableVarBinaryVector v = container.addOrGet(name, MinorType.VARBINARY, NullableVarBinaryVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public VarCharWriter varChar(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableVarCharVector v = container.addOrGet(name, MinorType.VARCHAR, NullableVarCharVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


  @Override
  public BitWriter bit(String name) {
    FieldWriter writer = fields.get(name.toLowerCase());
    if(writer == null) {
      ValueVector vector;
      ValueVector currentVector = container.getChild(name);
      NullableBitVector v = container.addOrGet(name, MinorType.BIT, NullableBitVector.class);
      writer = new PromotableWriter(v, container);
      vector = v;
      if (currentVector == null || currentVector != vector) {
        vector.allocateNewSafe();
      } 
      writer.setPosition(idx());
      fields.put(name.toLowerCase(), writer);
    }
    return writer;
  }


}
