/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.rounding;

import java.lang.reflect.Field;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.rounding.RoundingPolicy;

public class DefaultRoundingPolicy
implements RoundingPolicy {
    public final long chunkSize;
    public static final DefaultRoundingPolicy INSTANCE = new DefaultRoundingPolicy();

    private DefaultRoundingPolicy() {
        try {
            Field field = AllocationManager.class.getDeclaredField("CHUNK_SIZE");
            field.setAccessible(true);
            this.chunkSize = (Long)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get chunk size from allocation manager");
        }
    }

    @Override
    public int getRoundedSize(int requestSize) {
        return (long)requestSize < this.chunkSize ? BaseAllocator.nextPowerOfTwo(requestSize) : requestSize;
    }
}

