/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.arrow.memory.util.StackTrace;
import org.slf4j.Logger;

public class HistoricalLog {
    private final LinkedList<Event> history = new LinkedList();
    private final String idString;
    private Event firstEvent;
    private final int limit;

    public HistoricalLog(String idStringFormat, Object ... args) {
        this(Integer.MAX_VALUE, idStringFormat, args);
    }

    public HistoricalLog(int limit, String idStringFormat, Object ... args) {
        this.limit = limit;
        this.idString = String.format(idStringFormat, args);
    }

    public synchronized void recordEvent(String noteFormat, Object ... args) {
        String note = String.format(noteFormat, args);
        Event event = new Event(note);
        if (this.firstEvent == null) {
            this.firstEvent = event;
        }
        if (this.history.size() == this.limit) {
            this.history.removeFirst();
        }
        this.history.add(event);
    }

    public void buildHistory(StringBuilder sb, boolean includeStackTrace) {
        this.buildHistory(sb, 0, includeStackTrace);
    }

    public synchronized void buildHistory(StringBuilder sb, int indent, boolean includeStackTrace) {
        char[] indentation = new char[indent];
        char[] innerIndentation = new char[indent + 2];
        Arrays.fill(indentation, ' ');
        Arrays.fill(innerIndentation, ' ');
        sb.append(indentation).append("event log for: ").append(this.idString).append('\n');
        if (this.firstEvent != null) {
            sb.append(innerIndentation).append(this.firstEvent.time).append(' ').append(this.firstEvent.note).append('\n');
            if (includeStackTrace) {
                this.firstEvent.stackTrace.writeToBuilder(sb, indent + 2);
            }
            for (Event event : this.history) {
                if (event == this.firstEvent) continue;
                sb.append(innerIndentation).append("  ").append(event.time).append(' ').append(event.note).append('\n');
                if (!includeStackTrace) continue;
                event.stackTrace.writeToBuilder(sb, indent + 2);
                sb.append('\n');
            }
        }
    }

    public void logHistory(Logger logger) {
        StringBuilder sb = new StringBuilder();
        this.buildHistory(sb, 0, true);
        logger.debug(sb.toString());
    }

    private static class Event {
        private final String note;
        private final StackTrace stackTrace;
        private final long time;

        public Event(String note) {
            this.note = note;
            this.time = System.nanoTime();
            this.stackTrace = new StackTrace();
        }
    }
}

