/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.LargeBuffer;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnsafeDirectLittleEndian;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.OutOfMemoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledByteBufAllocatorL {
    private static final Logger memoryLogger = LoggerFactory.getLogger((String)"drill.allocator");
    private static final int MEMORY_LOGGER_FREQUENCY_SECONDS = 60;
    public static final String METRIC_PREFIX = "drill.allocator.";
    private final MetricRegistry registry;
    private final AtomicLong hugeBufferSize = new AtomicLong(0L);
    private final AtomicLong hugeBufferCount = new AtomicLong(0L);
    private final AtomicLong normalBufferSize = new AtomicLong(0L);
    private final AtomicLong normalBufferCount = new AtomicLong(0L);
    private final InnerAllocator allocator;
    public final UnsafeDirectLittleEndian empty;
    public static final boolean ASSERT_ENABLED;

    public PooledByteBufAllocatorL(MetricRegistry registry) {
        this.registry = registry;
        this.allocator = new InnerAllocator();
        this.empty = new UnsafeDirectLittleEndian(new DuplicatedByteBuf(Unpooled.EMPTY_BUFFER));
    }

    public UnsafeDirectLittleEndian allocate(int size) {
        try {
            return this.allocator.directBuffer(size, Integer.MAX_VALUE);
        }
        catch (OutOfMemoryError e) {
            throw new OutOfMemoryException("Failure allocating buffer.", e);
        }
    }

    public int getChunkSize() {
        return this.allocator.chunkSize;
    }

    static {
        boolean isAssertEnabled = false;
        if (!$assertionsDisabled) {
            isAssertEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT_ENABLED = isAssertEnabled;
    }

    private class InnerAllocator
    extends PooledByteBufAllocator {
        private final PoolArena<ByteBuffer>[] directArenas;
        private final MemoryStatusThread statusThread;
        private final Histogram largeBuffersHist;
        private final Histogram normalBuffersHist;
        private final int chunkSize;

        public InnerAllocator() {
            super(true);
            try {
                Field f = PooledByteBufAllocator.class.getDeclaredField("directArenas");
                f.setAccessible(true);
                this.directArenas = (PoolArena[])f.get((Object)this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure while initializing allocator.  Unable to retrieve direct arenas field.", e);
            }
            this.chunkSize = this.directArenas[0].chunkSize;
            if (memoryLogger.isTraceEnabled()) {
                this.statusThread = new MemoryStatusThread();
                this.statusThread.start();
            } else {
                this.statusThread = null;
            }
            this.removeOldMetrics();
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.normal.size", (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return PooledByteBufAllocatorL.this.normalBufferSize.get();
                }
            });
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.normal.count", (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return PooledByteBufAllocatorL.this.normalBufferCount.get();
                }
            });
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.huge.size", (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return PooledByteBufAllocatorL.this.hugeBufferSize.get();
                }
            });
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.huge.count", (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return PooledByteBufAllocatorL.this.hugeBufferCount.get();
                }
            });
            this.largeBuffersHist = PooledByteBufAllocatorL.this.registry.histogram("drill.allocator.huge.hist");
            this.normalBuffersHist = PooledByteBufAllocatorL.this.registry.histogram("drill.allocator.normal.hist");
        }

        private synchronized void removeOldMetrics() {
            PooledByteBufAllocatorL.this.registry.removeMatching(new MetricFilter(){

                public boolean matches(String name, Metric metric) {
                    return name.startsWith(PooledByteBufAllocatorL.METRIC_PREFIX);
                }
            });
        }

        private UnsafeDirectLittleEndian newDirectBufferL(int initialCapacity, int maxCapacity) {
            PoolThreadCache cache = this.threadCache();
            PoolArena directArena = cache.directArena;
            if (directArena != null) {
                if (initialCapacity > directArena.chunkSize) {
                    ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.directBuffer(initialCapacity, maxCapacity);
                    PooledByteBufAllocatorL.this.hugeBufferCount.incrementAndGet();
                    PooledByteBufAllocatorL.this.hugeBufferSize.addAndGet(buf.capacity());
                    this.largeBuffersHist.update(buf.capacity());
                    return new UnsafeDirectLittleEndian(new LargeBuffer(buf, PooledByteBufAllocatorL.this.hugeBufferSize, PooledByteBufAllocatorL.this.hugeBufferCount));
                }
                PooledByteBuf buf = directArena.allocate(cache, initialCapacity, maxCapacity);
                if (!(buf instanceof PooledUnsafeDirectByteBuf)) {
                    this.fail();
                }
                this.normalBuffersHist.update(buf.capacity());
                if (ASSERT_ENABLED) {
                    PooledByteBufAllocatorL.this.normalBufferSize.addAndGet(buf.capacity());
                    PooledByteBufAllocatorL.this.normalBufferCount.incrementAndGet();
                }
                return new UnsafeDirectLittleEndian((PooledUnsafeDirectByteBuf)buf, PooledByteBufAllocatorL.this.normalBufferCount, PooledByteBufAllocatorL.this.normalBufferSize);
            }
            throw this.fail();
        }

        private UnsupportedOperationException fail() {
            return new UnsupportedOperationException("Arrow requries that the JVM used supports access sun.misc.Unsafe.  This platform didn't provide that functionality.");
        }

        public UnsafeDirectLittleEndian directBuffer(int initialCapacity, int maxCapacity) {
            if (initialCapacity == 0 && maxCapacity == 0) {
                this.newDirectBuffer(initialCapacity, maxCapacity);
            }
            this.validate(initialCapacity, maxCapacity);
            return this.newDirectBufferL(initialCapacity, maxCapacity);
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException("Arrow doesn't support using heap buffers.");
        }

        private void validate(int initialCapacity, int maxCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expectd: 0+)");
            }
            if (initialCapacity > maxCapacity) {
                throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", initialCapacity, maxCapacity));
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.directArenas.length);
            buf.append(" direct arena(s):");
            buf.append(StringUtil.NEWLINE);
            for (PoolArena<ByteBuffer> a : this.directArenas) {
                buf.append(a);
            }
            buf.append("Large buffers outstanding: ");
            buf.append(PooledByteBufAllocatorL.this.hugeBufferCount.get());
            buf.append(" totaling ");
            buf.append(PooledByteBufAllocatorL.this.hugeBufferSize.get());
            buf.append(" bytes.");
            buf.append('\n');
            buf.append("Normal buffers outstanding: ");
            buf.append(PooledByteBufAllocatorL.this.normalBufferCount.get());
            buf.append(" totaling ");
            buf.append(PooledByteBufAllocatorL.this.normalBufferSize.get());
            buf.append(" bytes.");
            return buf.toString();
        }

        private class MemoryStatusThread
        extends Thread {
            public MemoryStatusThread() {
                super("memory-status-logger");
                this.setDaemon(true);
                this.setName("allocation.logger");
            }

            @Override
            public void run() {
                while (true) {
                    memoryLogger.trace("Memory Usage: \n{}", (Object)PooledByteBufAllocatorL.this.toString());
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }
}

